@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the app registration for providers that have app ids and app secrets
 * @property appId The App ID of the app used for login.
 * @property appSecretSettingName The app setting name that contains the app secret.
 */
public data class AppRegistrationResponse(
    public val appId: String? = null,
    public val appSecretSettingName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AppRegistrationResponse):
            AppRegistrationResponse = AppRegistrationResponse(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            appSecretSettingName = javaType.appSecretSettingName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
