@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The plan object in Azure Resource Manager, represents a marketplace plan.
 * @property name The name.
 * @property product The product.
 * @property promotionCode The promotion code.
 * @property publisher The publisher.
 * @property version Version of product.
 */
public data class ArmPlanResponse(
    public val name: String? = null,
    public val product: String? = null,
    public val promotionCode: String? = null,
    public val publisher: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ArmPlanResponse):
            ArmPlanResponse = ArmPlanResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
