@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the custom Open ID Connect provider.
 * @property enabled <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow of the custom Open ID Connect provider.
 * @property registration The configuration settings of the app registration for the custom Open ID Connect provider.
 */
public data class CustomOpenIdConnectProviderResponse(
    public val enabled: Boolean? = null,
    public val login: OpenIdConnectLoginResponse? = null,
    public val registration: OpenIdConnectRegistrationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.CustomOpenIdConnectProviderResponse):
            CustomOpenIdConnectProviderResponse = CustomOpenIdConnectProviderResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            login = javaType.login().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.OpenIdConnectLoginResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registration = javaType.registration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.OpenIdConnectRegistrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
