@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * API connection
 * @property etag Resource ETag
 * @property id Resource id
 * @property location Resource location
 * @property name Resource name
 * @property properties
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetConnectionResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: ApiConnectionDefinitionResponseProperties,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetConnectionResult):
            GetConnectionResult = GetConnectionResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.web.kotlin.outputs.ApiConnectionDefinitionResponseProperties.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
