@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property subnetResourceId The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
 * @property swiftSupported A flag that specifies if the scale unit this Web App is on supports Swift integration.
 * @property type Resource type.
 */
public data class GetWebAppSwiftVirtualNetworkConnectionSlotResult(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val subnetResourceId: String? = null,
    public val swiftSupported: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppSwiftVirtualNetworkConnectionSlotResult):
            GetWebAppSwiftVirtualNetworkConnectionSlotResult =
            GetWebAppSwiftVirtualNetworkConnectionSlotResult(
                id = javaType.id(),
                kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                subnetResourceId = javaType.subnetResourceId().map({ args0 -> args0 }).orElse(null),
                swiftSupported = javaType.swiftSupported().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
