@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Suppress

/**
 * Http logs configuration.
 * @property azureBlobStorage Http logs to azure blob storage configuration.
 * @property fileSystem Http logs to file system configuration.
 */
public data class HttpLogsConfigResponse(
    public val azureBlobStorage: AzureBlobStorageHttpLogsConfigResponse? = null,
    public val fileSystem: FileSystemHttpLogsConfigResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.HttpLogsConfigResponse):
            HttpLogsConfigResponse = HttpLogsConfigResponse(
            azureBlobStorage = javaType.azureBlobStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AzureBlobStorageHttpLogsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileSystem = javaType.fileSystem().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.FileSystemHttpLogsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
