@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * String dictionary resource.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property properties Connection strings.
 * @property type Resource type.
 */
public data class ListWebAppConnectionStringsResult(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val properties: Map<String, ConnStringValueTypePairResponse>,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListWebAppConnectionStringsResult):
            ListWebAppConnectionStringsResult = ListWebAppConnectionStringsResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.ConnStringValueTypePairResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            type = javaType.type(),
        )
    }
}
