@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User credentials used for publishing activity.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property publishingPassword Password used for publishing.
 * @property publishingPasswordHash Password hash used for publishing.
 * @property publishingPasswordHashSalt Password hash salt used for publishing.
 * @property publishingUserName Username used for publishing.
 * @property scmUri Url of SCM site.
 * @property type Resource type.
 */
public data class ListWebAppPublishingCredentialsResult(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val publishingPassword: String? = null,
    public val publishingPasswordHash: String? = null,
    public val publishingPasswordHashSalt: String? = null,
    public val publishingUserName: String,
    public val scmUri: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListWebAppPublishingCredentialsResult):
            ListWebAppPublishingCredentialsResult = ListWebAppPublishingCredentialsResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            publishingPassword = javaType.publishingPassword().map({ args0 -> args0 }).orElse(null),
            publishingPasswordHash = javaType.publishingPasswordHash().map({ args0 -> args0 }).orElse(null),
            publishingPasswordHashSalt = javaType.publishingPasswordHashSalt().map({ args0 ->
                args0
            }).orElse(null),
            publishingUserName = javaType.publishingUserName(),
            scmUri = javaType.scmUri().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
