@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Metric limits set on an app.
 * @property maxDiskSizeInMb Maximum allowed disk size usage in MB.
 * @property maxMemoryInMb Maximum allowed memory usage in MB.
 * @property maxPercentageCpu Maximum allowed CPU usage percentage.
 */
public data class SiteLimitsResponse(
    public val maxDiskSizeInMb: Double? = null,
    public val maxMemoryInMb: Double? = null,
    public val maxPercentageCpu: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.SiteLimitsResponse):
            SiteLimitsResponse = SiteLimitsResponse(
            maxDiskSizeInMb = javaType.maxDiskSizeInMb().map({ args0 -> args0 }).orElse(null),
            maxMemoryInMb = javaType.maxMemoryInMb().map({ args0 -> args0 }).orElse(null),
            maxPercentageCpu = javaType.maxPercentageCpu().map({ args0 -> args0 }).orElse(null),
        )
    }
}
