@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Trigger based on status code.
 * @property count Request Count.
 * @property path Request Path
 * @property status HTTP status code.
 * @property subStatus Request Sub Status.
 * @property timeInterval Time interval.
 * @property win32Status Win32 error code.
 */
public data class StatusCodesBasedTriggerResponse(
    public val count: Int? = null,
    public val path: String? = null,
    public val status: Int? = null,
    public val subStatus: Int? = null,
    public val timeInterval: String? = null,
    public val win32Status: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.StatusCodesBasedTriggerResponse):
            StatusCodesBasedTriggerResponse = StatusCodesBasedTriggerResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            subStatus = javaType.subStatus().map({ args0 -> args0 }).orElse(null),
            timeInterval = javaType.timeInterval().map({ args0 -> args0 }).orElse(null),
            win32Status = javaType.win32Status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
