@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Trigger based on range of status codes.
 * @property count Request Count.
 * @property path
 * @property statusCodes HTTP status code.
 * @property timeInterval Time interval.
 */
public data class StatusCodesRangeBasedTriggerResponse(
    public val count: Int? = null,
    public val path: String? = null,
    public val statusCodes: String? = null,
    public val timeInterval: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.StatusCodesRangeBasedTriggerResponse):
            StatusCodesRangeBasedTriggerResponse = StatusCodesRangeBasedTriggerResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            statusCodes = javaType.statusCodes().map({ args0 -> args0 }).orElse(null),
            timeInterval = javaType.timeInterval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
