@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Traffic weight assigned to a revision
 * @property latestRevision Indicates that the traffic weight belongs to a latest stable revision
 * @property revisionName Name of a revision
 * @property weight Traffic weight assigned to a revision
 */
public data class TrafficWeightResponse(
    public val latestRevision: Boolean? = null,
    public val revisionName: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.TrafficWeightResponse):
            TrafficWeightResponse = TrafficWeightResponse(
            latestRevision = javaType.latestRevision().map({ args0 -> args0 }).orElse(null),
            revisionName = javaType.revisionName().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
