@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specification for using a Virtual Network.
 * @property id Resource id of the Virtual Network.
 * @property name Name of the Virtual Network (read-only).
 * @property subnet Subnet within the Virtual Network.
 * @property type Resource type of the Virtual Network (read-only).
 */
public data class VirtualNetworkProfileResponse(
    public val id: String,
    public val name: String,
    public val subnet: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.VirtualNetworkProfileResponse):
            VirtualNetworkProfileResponse = VirtualNetworkProfileResponse(
            id = javaType.id(),
            name = javaType.name(),
            subnet = javaType.subnet().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
