@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.WebPubSubHubArgs.builder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.WebPubSubHubPropertiesArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.WebPubSubHubPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A hub setting
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### WebPubSubHubs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubHub = new AzureNative.WebPubSub.WebPubSubHub("webPubSubHub", new()
 *     {
 *         HubName = "exampleHub",
 *         Properties = new AzureNative.WebPubSub.Inputs.WebPubSubHubPropertiesArgs
 *         {
 *             AnonymousConnectPolicy = "allow",
 *             EventHandlers = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.EventHandlerArgs
 *                 {
 *                     Auth = new AzureNative.WebPubSub.Inputs.UpstreamAuthSettingsArgs
 *                     {
 *                         ManagedIdentity = new AzureNative.WebPubSub.Inputs.ManagedIdentitySettingsArgs
 *                         {
 *                             Resource = "abc",
 *                         },
 *                         Type = AzureNative.WebPubSub.UpstreamAuthType.ManagedIdentity,
 *                     },
 *                     SystemEvents = new[]
 *                     {
 *                         "connect",
 *                         "connected",
 *                     },
 *                     UrlTemplate = "http://host.com",
 *                     UserEventPattern = "*",
 *                 },
 *             },
 *             EventListeners = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.EventListenerArgs
 *                 {
 *                     Endpoint = new AzureNative.WebPubSub.Inputs.EventHubEndpointArgs
 *                     {
 *                         EventHubName = "eventHubName1",
 *                         FullyQualifiedNamespace = "example.servicebus.windows.net",
 *                         Type = "EventHub",
 *                     },
 *                     Filter = new AzureNative.WebPubSub.Inputs.EventNameFilterArgs
 *                     {
 *                         SystemEvents = new[]
 *                         {
 *                             "connected",
 *                             "disconnected",
 *                         },
 *                         Type = "EventName",
 *                         UserEventPattern = "*",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubHub(ctx, "webPubSubHub", &webpubsub.WebPubSubHubArgs{
 * 			HubName: pulumi.String("exampleHub"),
 * 			Properties: &webpubsub.WebPubSubHubPropertiesArgs{
 * 				AnonymousConnectPolicy: pulumi.String("allow"),
 * 				EventHandlers: webpubsub.EventHandlerArray{
 * 					&webpubsub.EventHandlerArgs{
 * 						Auth: &webpubsub.UpstreamAuthSettingsArgs{
 * 							ManagedIdentity: &webpubsub.ManagedIdentitySettingsArgs{
 * 								Resource: pulumi.String("abc"),
 * 							},
 * 							Type: pulumi.String(webpubsub.UpstreamAuthTypeManagedIdentity),
 * 						},
 * 						SystemEvents: pulumi.StringArray{
 * 							pulumi.String("connect"),
 * 							pulumi.String("connected"),
 * 						},
 * 						UrlTemplate:      pulumi.String("http://host.com"),
 * 						UserEventPattern: pulumi.String("*"),
 * 					},
 * 				},
 * 				EventListeners: []webpubsub.EventListenerArgs{
 * 					{
 * 						Endpoint: {
 * 							EventHubName:            pulumi.String("eventHubName1"),
 * 							FullyQualifiedNamespace: pulumi.String("example.servicebus.windows.net"),
 * 							Type:                    pulumi.String("EventHub"),
 * 						},
 * 						Filter: {
 * 							SystemEvents: pulumi.StringArray{
 * 								pulumi.String("connected"),
 * 								pulumi.String("disconnected"),
 * 							},
 * 							Type:             pulumi.String("EventName"),
 * 							UserEventPattern: pulumi.String("*"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myWebPubSubService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubHub;
 * import com.pulumi.azurenative.webpubsub.WebPubSubHubArgs;
 * import com.pulumi.azurenative.webpubsub.inputs.WebPubSubHubPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubHub = new WebPubSubHub("webPubSubHub", WebPubSubHubArgs.builder()
 *             .hubName("exampleHub")
 *             .properties(WebPubSubHubPropertiesArgs.builder()
 *                 .anonymousConnectPolicy("allow")
 *                 .eventHandlers(EventHandlerArgs.builder()
 *                     .auth(UpstreamAuthSettingsArgs.builder()
 *                         .managedIdentity(ManagedIdentitySettingsArgs.builder()
 *                             .resource("abc")
 *                             .build())
 *                         .type("ManagedIdentity")
 *                         .build())
 *                     .systemEvents(
 *                         "connect",
 *                         "connected")
 *                     .urlTemplate("http://host.com")
 *                     .userEventPattern("*")
 *                     .build())
 *                 .eventListeners(EventListenerArgs.builder()
 *                     .endpoint(EventHubEndpointArgs.builder()
 *                         .eventHubName("eventHubName1")
 *                         .fullyQualifiedNamespace("example.servicebus.windows.net")
 *                         .type("EventHub")
 *                         .build())
 *                     .filter(EventNameFilterArgs.builder()
 *                         .systemEvents(
 *                             "connected",
 *                             "disconnected")
 *                         .type("EventName")
 *                         .userEventPattern("*")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubHub exampleHub /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/hubs/{hubName}
 * ```
 * @property hubName The hub name.
 * @property properties Properties of a hub.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class WebPubSubHubArgs(
    public val hubName: Output<String>? = null,
    public val properties: Output<WebPubSubHubPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.WebPubSubHubArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.WebPubSubHubArgs =
        com.pulumi.azurenative.webpubsub.WebPubSubHubArgs.builder()
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebPubSubHubArgs].
 */
@PulumiTagMarker
public class WebPubSubHubArgsBuilder internal constructor() {
    private var hubName: Output<String>? = null

    private var properties: Output<WebPubSubHubPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The hub name.
     */
    @JvmName("saocjjbmknfxiqer")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value Properties of a hub.
     */
    @JvmName("lkkhavraocqqxbuh")
    public suspend fun properties(`value`: Output<WebPubSubHubPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vwopqrturlspgicq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("hvdevjttqcwmglex")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The hub name.
     */
    @JvmName("wikabbpjbuojhped")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value Properties of a hub.
     */
    @JvmName("kcbwjrgiwpkhqafi")
    public suspend fun properties(`value`: WebPubSubHubPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of a hub.
     */
    @JvmName("pbheuktuoqjlosie")
    public suspend fun properties(argument: suspend WebPubSubHubPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WebPubSubHubPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ivglunbgqcihdaqf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("xkhnvjehibnqrnrq")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): WebPubSubHubArgs = WebPubSubHubArgs(
        hubName = hubName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
