@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceSkuResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin as resourceSkuResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [WebPubSubReplica].
 */
@PulumiTagMarker
public class WebPubSubReplicaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebPubSubReplicaArgs = WebPubSubReplicaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebPubSubReplicaArgsBuilder.() -> Unit) {
        val builder = WebPubSubReplicaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebPubSubReplica {
        val builtJavaResource =
            com.pulumi.azurenative.webpubsub.WebPubSubReplica(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebPubSubReplica(builtJavaResource)
    }
}

/**
 * A class represent a replica resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### WebPubSubReplicas_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubReplica = new AzureNative.WebPubSub.WebPubSubReplica("webPubSubReplica", new()
 *     {
 *         Location = "eastus",
 *         ReplicaName = "myWebPubSubService-eastus",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *         Sku = new AzureNative.WebPubSub.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium_P1",
 *             Tier = AzureNative.WebPubSub.WebPubSubSkuTier.Premium,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubReplica(ctx, "webPubSubReplica", &webpubsub.WebPubSubReplicaArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ReplicaName:       pulumi.String("myWebPubSubService-eastus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myWebPubSubService"),
 * 			Sku: &webpubsub.ResourceSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium_P1"),
 * 				Tier:     pulumi.String(webpubsub.WebPubSubSkuTierPremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubReplica;
 * import com.pulumi.azurenative.webpubsub.WebPubSubReplicaArgs;
 * import com.pulumi.azurenative.webpubsub.inputs.ResourceSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubReplica = new WebPubSubReplica("webPubSubReplica", WebPubSubReplicaArgs.builder()
 *             .location("eastus")
 *             .replicaName("myWebPubSubService-eastus")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .sku(ResourceSkuArgs.builder()
 *                 .capacity(1)
 *                 .name("Premium_P1")
 *                 .tier("Premium")
 *                 .build())
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubReplica myWebPubSubService-eastus /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/replicas/{replicaName}
 * ```
 */
public class WebPubSubReplica internal constructor(
    override val javaResource: com.pulumi.azurenative.webpubsub.WebPubSubReplica,
) : KotlinCustomResource(javaResource, WebPubSubReplicaMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The billing information of the resource.
     */
    public val sku: Output<ResourceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebPubSubReplicaMapper : ResourceMapper<WebPubSubReplica> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.webpubsub.WebPubSubReplica::class == javaResource::class

    override fun map(javaResource: Resource): WebPubSubReplica = WebPubSubReplica(
        javaResource as
            com.pulumi.azurenative.webpubsub.WebPubSubReplica,
    )
}

/**
 * @see [WebPubSubReplica].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebPubSubReplica].
 */
public suspend fun webPubSubReplica(
    name: String,
    block: suspend WebPubSubReplicaResourceBuilder.() -> Unit,
): WebPubSubReplica {
    val builder = WebPubSubReplicaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebPubSubReplica].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webPubSubReplica(name: String): WebPubSubReplica {
    val builder = WebPubSubReplicaResourceBuilder()
    builder.name(name)
    return builder.build()
}
