@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public enum class PrivateLinkServiceConnectionStatus(
    public val javaValue: com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus.Disconnected),
    ;

    override fun toJava(): com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.enums.PrivateLinkServiceConnectionStatus):
            PrivateLinkServiceConnectionStatus =
            PrivateLinkServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
