@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Optional tier of this particular SKU. 'Standard' or 'Free'.
 * `Basic` is deprecated, use `Standard` instead.
 */
public enum class WebPubSubSkuTier(
    public val javaValue: com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier> {
    Free(com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier.Free),
    Basic(com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier.Basic),
    Standard(com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier.Standard),
    Premium(com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.enums.WebPubSubSkuTier):
            WebPubSubSkuTier = WebPubSubSkuTier.values().first { it.javaValue == javaType }
    }
}
