@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.NetworkACLArgs.builder
import com.pulumi.azurenative.webpubsub.kotlin.enums.WebPubSubRequestType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network ACL
 * @property allow Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 * @property deny Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 */
public data class NetworkACLArgs(
    public val allow: Output<List<Either<String, WebPubSubRequestType>>>? = null,
    public val deny: Output<List<Either<String, WebPubSubRequestType>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.NetworkACLArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.NetworkACLArgs =
        com.pulumi.azurenative.webpubsub.inputs.NetworkACLArgs.builder()
            .allow(
                allow?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .deny(
                deny?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkACLArgs].
 */
@PulumiTagMarker
public class NetworkACLArgsBuilder internal constructor() {
    private var allow: Output<List<Either<String, WebPubSubRequestType>>>? = null

    private var deny: Output<List<Either<String, WebPubSubRequestType>>>? = null

    /**
     * @param value Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("hqumbeysqrwykiky")
    public suspend fun allow(`value`: Output<List<Either<String, WebPubSubRequestType>>>) {
        this.allow = value
    }

    @JvmName("xakxncoxlcdjjpsy")
    public suspend fun allow(vararg values: Output<Either<String, WebPubSubRequestType>>) {
        this.allow = Output.all(values.asList())
    }

    /**
     * @param values Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("iyydiqotkisogkcb")
    public suspend fun allow(values: List<Output<Either<String, WebPubSubRequestType>>>) {
        this.allow = Output.all(values)
    }

    /**
     * @param value Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("ingahgeoehemkgbg")
    public suspend fun deny(`value`: Output<List<Either<String, WebPubSubRequestType>>>) {
        this.deny = value
    }

    @JvmName("yaslsuyipstuelug")
    public suspend fun deny(vararg values: Output<Either<String, WebPubSubRequestType>>) {
        this.deny = Output.all(values.asList())
    }

    /**
     * @param values Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("aocplucnscliehgw")
    public suspend fun deny(values: List<Output<Either<String, WebPubSubRequestType>>>) {
        this.deny = Output.all(values)
    }

    /**
     * @param value Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("yihjytucaeeahavi")
    public suspend fun allow(`value`: List<Either<String, WebPubSubRequestType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param values Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("lvqsrtngokjrjrsw")
    public suspend fun allow(vararg values: Either<String, WebPubSubRequestType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param value Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("gqpqfordeunqpusi")
    public suspend fun deny(`value`: List<Either<String, WebPubSubRequestType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deny = mapped
    }

    /**
     * @param values Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("vwapwkckiftkhluk")
    public suspend fun deny(vararg values: Either<String, WebPubSubRequestType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deny = mapped
    }

    internal fun build(): NetworkACLArgs = NetworkACLArgs(
        allow = allow,
        deny = deny,
    )
}
