@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.WebPubSubNetworkACLsArgs.builder
import com.pulumi.azurenative.webpubsub.kotlin.enums.ACLAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network ACLs for the resource
 * @property defaultAction Azure Networking ACL Action.
 * @property privateEndpoints ACLs for requests from private endpoints
 * @property publicNetwork Network ACL
 */
public data class WebPubSubNetworkACLsArgs(
    public val defaultAction: Output<Either<String, ACLAction>>? = null,
    public val privateEndpoints: Output<List<PrivateEndpointACLArgs>>? = null,
    public val publicNetwork: Output<NetworkACLArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.WebPubSubNetworkACLsArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.WebPubSubNetworkACLsArgs =
        com.pulumi.azurenative.webpubsub.inputs.WebPubSubNetworkACLsArgs.builder()
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateEndpoints(
                privateEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .publicNetwork(publicNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebPubSubNetworkACLsArgs].
 */
@PulumiTagMarker
public class WebPubSubNetworkACLsArgsBuilder internal constructor() {
    private var defaultAction: Output<Either<String, ACLAction>>? = null

    private var privateEndpoints: Output<List<PrivateEndpointACLArgs>>? = null

    private var publicNetwork: Output<NetworkACLArgs>? = null

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("xmhocoblevecvjij")
    public suspend fun defaultAction(`value`: Output<Either<String, ACLAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value ACLs for requests from private endpoints
     */
    @JvmName("fvjrhcypcxwjdhdc")
    public suspend fun privateEndpoints(`value`: Output<List<PrivateEndpointACLArgs>>) {
        this.privateEndpoints = value
    }

    @JvmName("igemoucdiywxkeee")
    public suspend fun privateEndpoints(vararg values: Output<PrivateEndpointACLArgs>) {
        this.privateEndpoints = Output.all(values.asList())
    }

    /**
     * @param values ACLs for requests from private endpoints
     */
    @JvmName("xalpvwpnlmqpfnhc")
    public suspend fun privateEndpoints(values: List<Output<PrivateEndpointACLArgs>>) {
        this.privateEndpoints = Output.all(values)
    }

    /**
     * @param value Network ACL
     */
    @JvmName("bjjlyganilcmaqge")
    public suspend fun publicNetwork(`value`: Output<NetworkACLArgs>) {
        this.publicNetwork = value
    }

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("cajnjmffdgvqavgo")
    public suspend fun defaultAction(`value`: Either<String, ACLAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("gbvnujdxlbovhsng")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ACLAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("hsnewnxysigntlqm")
    public fun defaultAction(`value`: ACLAction) {
        val toBeMapped = Either.ofRight<String, ACLAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value ACLs for requests from private endpoints
     */
    @JvmName("bmlbqwkgpnakssgk")
    public suspend fun privateEndpoints(`value`: List<PrivateEndpointACLArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoints = mapped
    }

    /**
     * @param argument ACLs for requests from private endpoints
     */
    @JvmName("wdansphgipylkgik")
    public suspend
    fun privateEndpoints(argument: List<suspend PrivateEndpointACLArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointACLArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpoints = mapped
    }

    /**
     * @param argument ACLs for requests from private endpoints
     */
    @JvmName("swvupcxrqssiihqg")
    public suspend fun privateEndpoints(
        vararg
        argument: suspend PrivateEndpointACLArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointACLArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpoints = mapped
    }

    /**
     * @param argument ACLs for requests from private endpoints
     */
    @JvmName("aefogdmxmytdabfs")
    public suspend fun privateEndpoints(argument: suspend PrivateEndpointACLArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrivateEndpointACLArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.privateEndpoints = mapped
    }

    /**
     * @param values ACLs for requests from private endpoints
     */
    @JvmName("usbodyxjvbflellm")
    public suspend fun privateEndpoints(vararg values: PrivateEndpointACLArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpoints = mapped
    }

    /**
     * @param value Network ACL
     */
    @JvmName("edanekricxqxookm")
    public suspend fun publicNetwork(`value`: NetworkACLArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetwork = mapped
    }

    /**
     * @param argument Network ACL
     */
    @JvmName("osfqrbrexnqphuus")
    public suspend fun publicNetwork(argument: suspend NetworkACLArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkACLArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicNetwork = mapped
    }

    internal fun build(): WebPubSubNetworkACLsArgs = WebPubSubNetworkACLsArgs(
        defaultAction = defaultAction,
        privateEndpoints = privateEndpoints,
        publicNetwork = publicNetwork,
    )
}
