@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A class represent a resource.
 * @property disableAadAuth DisableLocalAuth
 * Enable or disable aad auth
 * When set as true, connection with AuthType=aad won't work.
 * @property disableLocalAuth DisableLocalAuth
 * Enable or disable local auth with AccessKey
 * When set as true, connection with AccessKey=xxx won't work.
 * @property externalIP The publicly accessible IP of the resource.
 * @property hostName FQDN of the service instance.
 * @property hostNamePrefix Deprecated.
 * @property id Fully qualified resource Id for the resource.
 * @property identity A class represent managed identities used for request and response
 * @property liveTraceConfiguration Live trace configuration of a Microsoft.SignalRService resource.
 * @property location The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
 * @property name The name of the resource.
 * @property networkACLs Network ACLs for the resource
 * @property privateEndpointConnections Private endpoint connections to the resource.
 * @property provisioningState Provisioning state of the resource.
 * @property publicNetworkAccess Enable or disable public network access. Default to "Enabled".
 * When it's Enabled, network ACLs still apply.
 * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
 * @property publicPort The publicly accessible port of the resource which is designed for browser/client side usage.
 * @property resourceLogConfiguration Resource log configuration of a Microsoft.SignalRService resource.
 * @property serverPort The publicly accessible port of the resource which is designed for customer server side usage.
 * @property sharedPrivateLinkResources The list of shared private link resources.
 * @property sku The billing information of the resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Tags of the service which is a list of key value pairs that describe the resource.
 * @property tls TLS settings for the resource
 * @property type The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
 * @property version Version of the resource. Probably you need the same or higher version of client SDKs.
 */
public data class GetWebPubSubResult(
    public val disableAadAuth: Boolean? = null,
    public val disableLocalAuth: Boolean? = null,
    public val externalIP: String,
    public val hostName: String,
    public val hostNamePrefix: String,
    public val id: String,
    public val identity: ManagedIdentityResponse? = null,
    public val liveTraceConfiguration: LiveTraceConfigurationResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val networkACLs: WebPubSubNetworkACLsResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val publicPort: Int,
    public val resourceLogConfiguration: ResourceLogConfigurationResponse? = null,
    public val serverPort: Int,
    public val sharedPrivateLinkResources: List<SharedPrivateLinkResourceResponse>,
    public val sku: ResourceSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tls: WebPubSubTlsSettingsResponse? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.GetWebPubSubResult):
            GetWebPubSubResult = GetWebPubSubResult(
            disableAadAuth = javaType.disableAadAuth().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            externalIP = javaType.externalIP(),
            hostName = javaType.hostName(),
            hostNamePrefix = javaType.hostNamePrefix(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            liveTraceConfiguration = javaType.liveTraceConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.LiveTraceConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkACLs = javaType.networkACLs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubNetworkACLsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            publicPort = javaType.publicPort(),
            resourceLogConfiguration = javaType.resourceLogConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceLogConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serverPort = javaType.serverPort(),
            sharedPrivateLinkResources = javaType.sharedPrivateLinkResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.SharedPrivateLinkResourceResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubTlsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
