@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsesu.kotlin

import com.pulumi.azurenative.windowsesu.MultipleActivationKeyArgs.builder
import com.pulumi.azurenative.windowsesu.kotlin.enums.OsType
import com.pulumi.azurenative.windowsesu.kotlin.enums.SupportType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MAK key details.
 * Azure REST API version: 2019-09-16-preview. Prior API version in Azure Native 1.x: 2019-09-16-preview.
 * ## Example Usage
 * ### CreateMultipleActivationKey
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var multipleActivationKey = new AzureNative.WindowsESU.MultipleActivationKey("multipleActivationKey", new()
 *     {
 *         AgreementNumber = "1a2b45ag",
 *         InstalledServerNumber = 100,
 *         IsEligible = true,
 *         Location = "East US",
 *         MultipleActivationKeyName = "server08-key-2019",
 *         OsType = AzureNative.WindowsESU.OsType.WindowsServer2008,
 *         ResourceGroupName = "testgr1",
 *         SupportType = AzureNative.WindowsESU.SupportType.SupplementalServicing,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/windowsesu/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := windowsesu.NewMultipleActivationKey(ctx, "multipleActivationKey", &windowsesu.MultipleActivationKeyArgs{
 * 			AgreementNumber:           pulumi.String("1a2b45ag"),
 * 			InstalledServerNumber:     pulumi.Int(100),
 * 			IsEligible:                pulumi.Bool(true),
 * 			Location:                  pulumi.String("East US"),
 * 			MultipleActivationKeyName: pulumi.String("server08-key-2019"),
 * 			OsType:                    pulumi.String(windowsesu.OsTypeWindowsServer2008),
 * 			ResourceGroupName:         pulumi.String("testgr1"),
 * 			SupportType:               pulumi.String(windowsesu.SupportTypeSupplementalServicing),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.windowsesu.MultipleActivationKey;
 * import com.pulumi.azurenative.windowsesu.MultipleActivationKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var multipleActivationKey = new MultipleActivationKey("multipleActivationKey", MultipleActivationKeyArgs.builder()
 *             .agreementNumber("1a2b45ag")
 *             .installedServerNumber(100)
 *             .isEligible(true)
 *             .location("East US")
 *             .multipleActivationKeyName("server08-key-2019")
 *             .osType("WindowsServer2008")
 *             .resourceGroupName("testgr1")
 *             .supportType("SupplementalServicing")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:windowsesu:MultipleActivationKey server08-key-2019 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsESU/multipleActivationKeys/{multipleActivationKeyName}
 * ```
 * @property agreementNumber Agreement number under which the key is requested.
 * @property installedServerNumber Number of activations/servers using the MAK key.
 * @property isEligible <code> true </code> if user has eligible on-premises Windows physical or virtual machines, and that the requested key will only be used in their organization; <code> false </code> otherwise.
 * @property location The geo-location where the resource lives
 * @property multipleActivationKeyName The name of the MAK key.
 * @property osType Type of OS for which the key is requested.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property supportType Type of support
 * @property tags Resource tags.
 */
public data class MultipleActivationKeyArgs(
    public val agreementNumber: Output<String>? = null,
    public val installedServerNumber: Output<Int>? = null,
    public val isEligible: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val multipleActivationKeyName: Output<String>? = null,
    public val osType: Output<Either<String, OsType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val supportType: Output<Either<String, SupportType>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.windowsesu.MultipleActivationKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.windowsesu.MultipleActivationKeyArgs =
        com.pulumi.azurenative.windowsesu.MultipleActivationKeyArgs.builder()
            .agreementNumber(agreementNumber?.applyValue({ args0 -> args0 }))
            .installedServerNumber(installedServerNumber?.applyValue({ args0 -> args0 }))
            .isEligible(isEligible?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .multipleActivationKeyName(multipleActivationKeyName?.applyValue({ args0 -> args0 }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .supportType(
                supportType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MultipleActivationKeyArgs].
 */
@PulumiTagMarker
public class MultipleActivationKeyArgsBuilder internal constructor() {
    private var agreementNumber: Output<String>? = null

    private var installedServerNumber: Output<Int>? = null

    private var isEligible: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var multipleActivationKeyName: Output<String>? = null

    private var osType: Output<Either<String, OsType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var supportType: Output<Either<String, SupportType>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Agreement number under which the key is requested.
     */
    @JvmName("tjvqkmpkwqngjpit")
    public suspend fun agreementNumber(`value`: Output<String>) {
        this.agreementNumber = value
    }

    /**
     * @param value Number of activations/servers using the MAK key.
     */
    @JvmName("vedtqsdqxcwerkud")
    public suspend fun installedServerNumber(`value`: Output<Int>) {
        this.installedServerNumber = value
    }

    /**
     * @param value <code> true </code> if user has eligible on-premises Windows physical or virtual machines, and that the requested key will only be used in their organization; <code> false </code> otherwise.
     */
    @JvmName("srrsneogkoblgjcd")
    public suspend fun isEligible(`value`: Output<Boolean>) {
        this.isEligible = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ykqhoxvamrvwqemp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the MAK key.
     */
    @JvmName("xwwaooyymmdajycu")
    public suspend fun multipleActivationKeyName(`value`: Output<String>) {
        this.multipleActivationKeyName = value
    }

    /**
     * @param value Type of OS for which the key is requested.
     */
    @JvmName("kvabttgxglkorgep")
    public suspend fun osType(`value`: Output<Either<String, OsType>>) {
        this.osType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gphedfldilsolhfd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Type of support
     */
    @JvmName("rwaeobcfjaptaqeo")
    public suspend fun supportType(`value`: Output<Either<String, SupportType>>) {
        this.supportType = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jvsbdyqlhctdjgxx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Agreement number under which the key is requested.
     */
    @JvmName("nbhhrnmvmtpehhud")
    public suspend fun agreementNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agreementNumber = mapped
    }

    /**
     * @param value Number of activations/servers using the MAK key.
     */
    @JvmName("sodclwqiftchoqej")
    public suspend fun installedServerNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installedServerNumber = mapped
    }

    /**
     * @param value <code> true </code> if user has eligible on-premises Windows physical or virtual machines, and that the requested key will only be used in their organization; <code> false </code> otherwise.
     */
    @JvmName("iaiqaghpluvxootc")
    public suspend fun isEligible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEligible = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cexwwkltcgwicjxu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the MAK key.
     */
    @JvmName("biifoghipgvhhsne")
    public suspend fun multipleActivationKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multipleActivationKeyName = mapped
    }

    /**
     * @param value Type of OS for which the key is requested.
     */
    @JvmName("uvujgxbcpycarxtb")
    public suspend fun osType(`value`: Either<String, OsType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Type of OS for which the key is requested.
     */
    @JvmName("fnpcpytuaqenabtt")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Type of OS for which the key is requested.
     */
    @JvmName("efogvvpvckmgchvj")
    public fun osType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dpgomqsmlpfyttph")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Type of support
     */
    @JvmName("ghnagbvbjupkhutq")
    public suspend fun supportType(`value`: Either<String, SupportType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportType = mapped
    }

    /**
     * @param value Type of support
     */
    @JvmName("duvwenvwvljjkium")
    public fun supportType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportType = mapped
    }

    /**
     * @param value Type of support
     */
    @JvmName("uqjmbjbkgjjylnco")
    public fun supportType(`value`: SupportType) {
        val toBeMapped = Either.ofRight<String, SupportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportType = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vpmqrtmuaufvguks")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jumsuiwsexsmlben")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MultipleActivationKeyArgs = MultipleActivationKeyArgs(
        agreementNumber = agreementNumber,
        installedServerNumber = installedServerNumber,
        isEligible = isEligible,
        location = location,
        multipleActivationKeyName = multipleActivationKeyName,
        osType = osType,
        resourceGroupName = resourceGroupName,
        supportType = supportType,
        tags = tags,
    )
}
