@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsiot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.azurenative.windowsiot.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * The description of the Windows IoT Device Service.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2018-02-16-preview.
 * ## Example Usage
 * ### Service_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.WindowsIoT.Service("service", new()
 *     {
 *         AdminDomainName = "d.e.f",
 *         BillingDomainName = "a.b.c",
 *         DeviceName = "service4445",
 *         Location = "East US",
 *         Notes = "blah",
 *         Quantity = 1000000,
 *         ResourceGroupName = "res9101",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/windowsiot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := windowsiot.NewService(ctx, "service", &windowsiot.ServiceArgs{
 * 			AdminDomainName:   pulumi.String("d.e.f"),
 * 			BillingDomainName: pulumi.String("a.b.c"),
 * 			DeviceName:        pulumi.String("service4445"),
 * 			Location:          pulumi.String("East US"),
 * 			Notes:             pulumi.String("blah"),
 * 			Quantity:          pulumi.Float64(1000000),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.windowsiot.Service;
 * import com.pulumi.azurenative.windowsiot.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .adminDomainName("d.e.f")
 *             .billingDomainName("a.b.c")
 *             .deviceName("service4445")
 *             .location("East US")
 *             .notes("blah")
 *             .quantity(1000000)
 *             .resourceGroupName("res9101")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:windowsiot:Service myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsIoT/deviceServices/{deviceName}
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.azurenative.windowsiot.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * Windows IoT Device Service OEM AAD domain
     */
    public val adminDomainName: Output<String>?
        get() = javaResource.adminDomainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Windows IoT Device Service ODM AAD domain
     */
    public val billingDomainName: Output<String>?
        get() = javaResource.billingDomainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Windows IoT Device Service notes.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Windows IoT Device Service device allocation,
     */
    public val quantity: Output<Double>?
        get() = javaResource.quantity().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Windows IoT Device Service start date,
     */
    public val startDate: Output<String>
        get() = javaResource.startDate().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.windowsiot.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.azurenative.windowsiot.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit):
    Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
