@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ConnectorErrorDefinitionResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.ConnectorErrorDefinitionResponse.Companion.toKotlin as connectorErrorDefinitionResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ACSSBackupConnection].
 */
@PulumiTagMarker
public class ACSSBackupConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ACSSBackupConnectionArgs = ACSSBackupConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ACSSBackupConnectionArgsBuilder.() -> Unit) {
        val builder = ACSSBackupConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ACSSBackupConnection {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.ACSSBackupConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ACSSBackupConnection(builtJavaResource)
    }
}

/**
 * Define the backup connection resource of virtual instance for SAP..
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Create a HANA backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.HanaBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultHanaPolicy",
 *                 ProtectedItemsCount = 0,
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = false,
 *                     Issqlcompression = false,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Full,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                         {
 *                             MonthlySchedule = new AzureNative.Workloads.Inputs.MonthlyRetentionScheduleArgs
 *                             {
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 60,
 *                                     DurationType = AzureNative.Workloads.RetentionDurationType.Months,
 *                                 },
 *                                 RetentionScheduleFormatType = AzureNative.Workloads.RetentionScheduleFormat.Weekly,
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             RetentionPolicyType = "LongTermRetentionPolicy",
 *                             WeeklySchedule = new AzureNative.Workloads.Inputs.WeeklyRetentionScheduleArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.Workloads.DayOfWeek.Sunday,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 104,
 *                                     DurationType = AzureNative.Workloads.RetentionDurationType.Weeks,
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             YearlySchedule = new AzureNative.Workloads.Inputs.YearlyRetentionScheduleArgs
 *                             {
 *                                 MonthsOfYear = new[]
 *                                 {
 *                                     AzureNative.Workloads.MonthOfYear.January,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 10,
 *                                     DurationType = AzureNative.Workloads.RetentionDurationType.Years,
 *                                 },
 *                                 RetentionScheduleFormatType = AzureNative.Workloads.RetentionScheduleFormat.Weekly,
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Weekly,
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-11-29T19:30:00.000Z",
 *                             },
 *                         },
 *                         TieringPolicy =
 *                         {
 *                             { "ArchivedRP", new AzureNative.Workloads.Inputs.TieringPolicyArgs
 *                             {
 *                                 TieringMode = AzureNative.Workloads.TieringMode.DoNotTier,
 *                             } },
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Differential,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 30,
 *                                 DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Monday,
 *                             },
 *                             ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Weekly,
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-09-29T02:00:00Z",
 *                             },
 *                             ScheduleWeeklyFrequency = 0,
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Log,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 20,
 *                                 DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.LogSchedulePolicyArgs
 *                         {
 *                             ScheduleFrequencyInMins = 120,
 *                             SchedulePolicyType = "LogSchedulePolicy",
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = AzureNative.Workloads.WorkloadType.SAPHanaDatabase,
 *             },
 *             BackupType = "HANA",
 *             DbInstanceSnapshotBackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultDbInstanceSnapshotPolicy",
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = false,
 *                     Issqlcompression = false,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.SnapshotFull,
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Daily,
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2023-09-18T06:30:00.000Z",
 *                             },
 *                         },
 *                         SnapshotBackupAdditionalDetails = new AzureNative.Workloads.Inputs.SnapshotBackupAdditionalDetailsArgs
 *                         {
 *                             InstantRPDetails = "test-rg",
 *                             InstantRpRetentionRangeInDays = 1,
 *                             UserAssignedManagedIdentityDetails = new AzureNative.Workloads.Inputs.UserAssignedManagedIdentityDetailsArgs
 *                             {
 *                                 IdentityArmId = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testMsi",
 *                                 IdentityName = "testMsi",
 *                                 UserAssignedIdentityProperties = new AzureNative.Workloads.Inputs.UserAssignedIdentityPropertiesArgs
 *                                 {
 *                                     ClientId = "c3a877cf-51f8-4031-8f17-ab562d1e7737",
 *                                     PrincipalId = "2f5834bd-4b86-4d85-a8df-6dd829a6418c",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = AzureNative.Workloads.WorkloadType.SAPHanaDBInstance,
 *             },
 *             HdbuserstoreKeyName = "abcd",
 *             InstanceNumber = "00",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *             SslConfiguration = new AzureNative.Workloads.Inputs.SSLConfigurationArgs
 *             {
 *                 SslCryptoProvider = AzureNative.Workloads.SslCryptoProvider.Commoncrypto,
 *                 SslHostNameInCertificate = "hostname",
 *                 SslKeyStore = "sapsrv.pse",
 *                 SslTrustStore = "sapsrv.pse",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.HanaBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultHanaPolicy",
 * 					ProtectedItemsCount:  0,
 * 					Settings: workloads.Settings{
 * 						IsCompression:    false,
 * 						Issqlcompression: false,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: workloads.PolicyTypeFull,
 * 							RetentionPolicy: {
 * 								MonthlySchedule: {
 * 									RetentionDuration: {
 * 										Count:        60,
 * 										DurationType: workloads.RetentionDurationTypeMonths,
 * 									},
 * 									RetentionScheduleFormatType: workloads.RetentionScheduleFormatWeekly,
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								RetentionPolicyType: "LongTermRetentionPolicy",
 * 								WeeklySchedule: {
 * 									DaysOfTheWeek: []workloads.DayOfWeek{
 * 										workloads.DayOfWeekSunday,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        104,
 * 										DurationType: workloads.RetentionDurationTypeWeeks,
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								YearlySchedule: {
 * 									MonthsOfYear: []workloads.MonthOfYear{
 * 										workloads.MonthOfYearJanuary,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        10,
 * 										DurationType: workloads.RetentionDurationTypeYears,
 * 									},
 * 									RetentionScheduleFormatType: workloads.RetentionScheduleFormatWeekly,
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekSunday,
 * 								},
 * 								ScheduleRunFrequency: workloads.ScheduleRunTypeWeekly,
 * 								ScheduleRunTimes: []string{
 * 									"2022-11-29T19:30:00.000Z",
 * 								},
 * 							},
 * 							TieringPolicy: {
 * 								ArchivedRP: {
 * 									TieringMode: workloads.TieringModeDoNotTier,
 * 								},
 * 							},
 * 						},
 * 						{
 * 							PolicyType: workloads.PolicyTypeDifferential,
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        30,
 * 									DurationType: workloads.RetentionDurationTypeDays,
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekMonday,
 * 								},
 * 								ScheduleRunFrequency: workloads.ScheduleRunTypeWeekly,
 * 								ScheduleRunTimes: []string{
 * 									"2022-09-29T02:00:00Z",
 * 								},
 * 								ScheduleWeeklyFrequency: 0,
 * 							},
 * 						},
 * 						{
 * 							PolicyType: workloads.PolicyTypeLog,
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        20,
 * 									DurationType: workloads.RetentionDurationTypeDays,
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								ScheduleFrequencyInMins: 120,
 * 								SchedulePolicyType:      "LogSchedulePolicy",
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: workloads.WorkloadTypeSAPHanaDatabase,
 * 				},
 * 				BackupType: "HANA",
 * 				DbInstanceSnapshotBackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultDbInstanceSnapshotPolicy",
 * 					Settings: workloads.Settings{
 * 						IsCompression:    false,
 * 						Issqlcompression: false,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: workloads.PolicyTypeSnapshotFull,
 * 							SchedulePolicy: {
 * 								SchedulePolicyType:   "SimpleSchedulePolicy",
 * 								ScheduleRunFrequency: workloads.ScheduleRunTypeDaily,
 * 								ScheduleRunTimes: []string{
 * 									"2023-09-18T06:30:00.000Z",
 * 								},
 * 							},
 * 							SnapshotBackupAdditionalDetails: {
 * 								InstantRPDetails:              "test-rg",
 * 								InstantRpRetentionRangeInDays: 1,
 * 								UserAssignedManagedIdentityDetails: {
 * 									IdentityArmId: "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testMsi",
 * 									IdentityName:  "testMsi",
 * 									UserAssignedIdentityProperties: {
 * 										ClientId:    "c3a877cf-51f8-4031-8f17-ab562d1e7737",
 * 										PrincipalId: "2f5834bd-4b86-4d85-a8df-6dd829a6418c",
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: workloads.WorkloadTypeSAPHanaDBInstance,
 * 				},
 * 				HdbuserstoreKeyName: "abcd",
 * 				InstanceNumber:      "00",
 * 				RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * 					Name:          "test-vault",
 * 					ResourceGroup: "test-rg",
 * 					VaultType:     "New",
 * 				},
 * 				SslConfiguration: workloads.SSLConfiguration{
 * 					SslCryptoProvider:        workloads.SslCryptoProviderCommoncrypto,
 * 					SslHostNameInCertificate: "hostname",
 * 					SslKeyStore:              "sapsrv.pse",
 * 					SslTrustStore:            "sapsrv.pse",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(HanaBackupDataArgs.builder()
 *                 .backupPolicy(DBBackupPolicyPropertiesArgs.builder()
 *                     .backupManagementType("AzureWorkload")
 *                     .name("defaultHanaPolicy")
 *                     .protectedItemsCount(0)
 *                     .settings(SettingsArgs.builder()
 *                         .isCompression(false)
 *                         .issqlcompression(false)
 *                         .timeZone("UTC")
 *                         .build())
 *                     .subProtectionPolicy(
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Full")
 *                             .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                                 .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                                     .retentionDuration(RetentionDurationArgs.builder()
 *                                         .count(60)
 *                                         .durationType("Months")
 *                                         .build())
 *                                     .retentionScheduleFormatType("Weekly")
 *                                     .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                                         .daysOfTheWeek("Sunday")
 *                                         .weeksOfTheMonth("First")
 *                                         .build())
 *                                     .retentionTimes("2022-11-29T19:30:00.000Z")
 *                                     .build())
 *                                 .retentionPolicyType("LongTermRetentionPolicy")
 *                                 .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                                     .daysOfTheWeek("Sunday")
 *                                     .retentionDuration(RetentionDurationArgs.builder()
 *                                         .count(104)
 *                                         .durationType("Weeks")
 *                                         .build())
 *                                     .retentionTimes("2022-11-29T19:30:00.000Z")
 *                                     .build())
 *                                 .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                                     .monthsOfYear("January")
 *                                     .retentionDuration(RetentionDurationArgs.builder()
 *                                         .count(10)
 *                                         .durationType("Years")
 *                                         .build())
 *                                     .retentionScheduleFormatType("Weekly")
 *                                     .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                                         .daysOfTheWeek("Sunday")
 *                                         .weeksOfTheMonth("First")
 *                                         .build())
 *                                     .retentionTimes("2022-11-29T19:30:00.000Z")
 *                                     .build())
 *                                 .build())
 *                             .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                                 .schedulePolicyType("SimpleSchedulePolicy")
 *                                 .scheduleRunDays("Sunday")
 *                                 .scheduleRunFrequency("Weekly")
 *                                 .scheduleRunTimes("2022-11-29T19:30:00.000Z")
 *                                 .build())
 *                             .tieringPolicy(Map.of("ArchivedRP", Map.of("tieringMode", "DoNotTier")))
 *                             .build(),
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Differential")
 *                             .retentionPolicy(SimpleRetentionPolicyArgs.builder()
 *                                 .retentionDuration(RetentionDurationArgs.builder()
 *                                     .count(30)
 *                                     .durationType("Days")
 *                                     .build())
 *                                 .retentionPolicyType("SimpleRetentionPolicy")
 *                                 .build())
 *                             .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                                 .schedulePolicyType("SimpleSchedulePolicy")
 *                                 .scheduleRunDays("Monday")
 *                                 .scheduleRunFrequency("Weekly")
 *                                 .scheduleRunTimes("2022-09-29T02:00:00Z")
 *                                 .scheduleWeeklyFrequency(0)
 *                                 .build())
 *                             .build(),
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Log")
 *                             .retentionPolicy(SimpleRetentionPolicyArgs.builder()
 *                                 .retentionDuration(RetentionDurationArgs.builder()
 *                                     .count(20)
 *                                     .durationType("Days")
 *                                     .build())
 *                                 .retentionPolicyType("SimpleRetentionPolicy")
 *                                 .build())
 *                             .schedulePolicy(LogSchedulePolicyArgs.builder()
 *                                 .scheduleFrequencyInMins(120)
 *                                 .schedulePolicyType("LogSchedulePolicy")
 *                                 .build())
 *                             .build())
 *                     .workLoadType("SAPHanaDatabase")
 *                     .build())
 *                 .backupType("HANA")
 *                 .dbInstanceSnapshotBackupPolicy(DBBackupPolicyPropertiesArgs.builder()
 *                     .backupManagementType("AzureWorkload")
 *                     .name("defaultDbInstanceSnapshotPolicy")
 *                     .settings(SettingsArgs.builder()
 *                         .isCompression(false)
 *                         .issqlcompression(false)
 *                         .timeZone("UTC")
 *                         .build())
 *                     .subProtectionPolicy(SubProtectionPolicyArgs.builder()
 *                         .policyType("SnapshotFull")
 *                         .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                             .schedulePolicyType("SimpleSchedulePolicy")
 *                             .scheduleRunFrequency("Daily")
 *                             .scheduleRunTimes("2023-09-18T06:30:00.000Z")
 *                             .build())
 *                         .snapshotBackupAdditionalDetails(SnapshotBackupAdditionalDetailsArgs.builder()
 *                             .instantRPDetails("test-rg")
 *                             .instantRpRetentionRangeInDays(1)
 *                             .userAssignedManagedIdentityDetails(UserAssignedManagedIdentityDetailsArgs.builder()
 *                                 .identityArmId("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testMsi")
 *                                 .identityName("testMsi")
 *                                 .userAssignedIdentityProperties(UserAssignedIdentityPropertiesArgs.builder()
 *                                     .clientId("c3a877cf-51f8-4031-8f17-ab562d1e7737")
 *                                     .principalId("2f5834bd-4b86-4d85-a8df-6dd829a6418c")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .workLoadType("SAPHanaDBInstance")
 *                     .build())
 *                 .hdbuserstoreKeyName("abcd")
 *                 .instanceNumber("00")
 *                 .recoveryServicesVault(NewRecoveryServicesVaultArgs.builder()
 *                     .name("test-vault")
 *                     .resourceGroup("test-rg")
 *                     .vaultType("New")
 *                     .build())
 *                 .sslConfiguration(SSLConfigurationArgs.builder()
 *                     .sslCryptoProvider("commoncrypto")
 *                     .sslHostNameInCertificate("hostname")
 *                     .sslKeyStore("sapsrv.pse")
 *                     .sslTrustStore("sapsrv.pse")
 *                     .build())
 *                 .build())
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SQL backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.SqlBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultSqlPolicy",
 *                 ProtectedItemsCount = 0,
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = true,
 *                     Issqlcompression = true,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Full,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                         {
 *                             MonthlySchedule = new AzureNative.Workloads.Inputs.MonthlyRetentionScheduleArgs
 *                             {
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 60,
 *                                     DurationType = AzureNative.Workloads.RetentionDurationType.Months,
 *                                 },
 *                                 RetentionScheduleFormatType = AzureNative.Workloads.RetentionScheduleFormat.Weekly,
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             RetentionPolicyType = "LongTermRetentionPolicy",
 *                             WeeklySchedule = new AzureNative.Workloads.Inputs.WeeklyRetentionScheduleArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.Workloads.DayOfWeek.Sunday,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 104,
 *                                     DurationType = AzureNative.Workloads.RetentionDurationType.Weeks,
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             YearlySchedule = new AzureNative.Workloads.Inputs.YearlyRetentionScheduleArgs
 *                             {
 *                                 MonthsOfYear = new[]
 *                                 {
 *                                     AzureNative.Workloads.MonthOfYear.January,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 10,
 *                                     DurationType = AzureNative.Workloads.RetentionDurationType.Years,
 *                                 },
 *                                 RetentionScheduleFormatType = AzureNative.Workloads.RetentionScheduleFormat.Weekly,
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Weekly,
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-11-29T19:30:00.000Z",
 *                             },
 *                         },
 *                         TieringPolicy =
 *                         {
 *                             { "ArchivedRP", new AzureNative.Workloads.Inputs.TieringPolicyArgs
 *                             {
 *                                 Duration = 45,
 *                                 DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                                 TieringMode = AzureNative.Workloads.TieringMode.TierAfter,
 *                             } },
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Differential,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 30,
 *                                 DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Monday,
 *                             },
 *                             ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Weekly,
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-09-29T02:00:00Z",
 *                             },
 *                             ScheduleWeeklyFrequency = 0,
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Log,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 20,
 *                                 DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.LogSchedulePolicyArgs
 *                         {
 *                             ScheduleFrequencyInMins = 120,
 *                             SchedulePolicyType = "LogSchedulePolicy",
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = AzureNative.Workloads.WorkloadType.SQLDataBase,
 *             },
 *             BackupType = "SQL",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.SqlBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultSqlPolicy",
 * 					ProtectedItemsCount:  0,
 * 					Settings: workloads.Settings{
 * 						IsCompression:    true,
 * 						Issqlcompression: true,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: workloads.PolicyTypeFull,
 * 							RetentionPolicy: {
 * 								MonthlySchedule: {
 * 									RetentionDuration: {
 * 										Count:        60,
 * 										DurationType: workloads.RetentionDurationTypeMonths,
 * 									},
 * 									RetentionScheduleFormatType: workloads.RetentionScheduleFormatWeekly,
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								RetentionPolicyType: "LongTermRetentionPolicy",
 * 								WeeklySchedule: {
 * 									DaysOfTheWeek: []workloads.DayOfWeek{
 * 										workloads.DayOfWeekSunday,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        104,
 * 										DurationType: workloads.RetentionDurationTypeWeeks,
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								YearlySchedule: {
 * 									MonthsOfYear: []workloads.MonthOfYear{
 * 										workloads.MonthOfYearJanuary,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        10,
 * 										DurationType: workloads.RetentionDurationTypeYears,
 * 									},
 * 									RetentionScheduleFormatType: workloads.RetentionScheduleFormatWeekly,
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekSunday,
 * 								},
 * 								ScheduleRunFrequency: workloads.ScheduleRunTypeWeekly,
 * 								ScheduleRunTimes: []string{
 * 									"2022-11-29T19:30:00.000Z",
 * 								},
 * 							},
 * 							TieringPolicy: {
 * 								ArchivedRP: {
 * 									Duration:     45,
 * 									DurationType: workloads.RetentionDurationTypeDays,
 * 									TieringMode:  workloads.TieringModeTierAfter,
 * 								},
 * 							},
 * 						},
 * 						{
 * 							PolicyType: workloads.PolicyTypeDifferential,
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        30,
 * 									DurationType: workloads.RetentionDurationTypeDays,
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekMonday,
 * 								},
 * 								ScheduleRunFrequency: workloads.ScheduleRunTypeWeekly,
 * 								ScheduleRunTimes: []string{
 * 									"2022-09-29T02:00:00Z",
 * 								},
 * 								ScheduleWeeklyFrequency: 0,
 * 							},
 * 						},
 * 						{
 * 							PolicyType: workloads.PolicyTypeLog,
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        20,
 * 									DurationType: workloads.RetentionDurationTypeDays,
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								ScheduleFrequencyInMins: 120,
 * 								SchedulePolicyType:      "LogSchedulePolicy",
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: workloads.WorkloadTypeSQLDataBase,
 * 				},
 * 				BackupType: "SQL",
 * 				RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * 					Name:          "test-vault",
 * 					ResourceGroup: "test-rg",
 * 					VaultType:     "New",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(HanaBackupDataArgs.builder()
 *                 .backupPolicy(DBBackupPolicyPropertiesArgs.builder()
 *                     .backupManagementType("AzureWorkload")
 *                     .name("defaultSqlPolicy")
 *                     .protectedItemsCount(0)
 *                     .settings(SettingsArgs.builder()
 *                         .isCompression(true)
 *                         .issqlcompression(true)
 *                         .timeZone("UTC")
 *                         .build())
 *                     .subProtectionPolicy(
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Full")
 *                             .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                                 .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                                     .retentionDuration(RetentionDurationArgs.builder()
 *                                         .count(60)
 *                                         .durationType("Months")
 *                                         .build())
 *                                     .retentionScheduleFormatType("Weekly")
 *                                     .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                                         .daysOfTheWeek("Sunday")
 *                                         .weeksOfTheMonth("First")
 *                                         .build())
 *                                     .retentionTimes("2022-11-29T19:30:00.000Z")
 *                                     .build())
 *                                 .retentionPolicyType("LongTermRetentionPolicy")
 *                                 .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                                     .daysOfTheWeek("Sunday")
 *                                     .retentionDuration(RetentionDurationArgs.builder()
 *                                         .count(104)
 *                                         .durationType("Weeks")
 *                                         .build())
 *                                     .retentionTimes("2022-11-29T19:30:00.000Z")
 *                                     .build())
 *                                 .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                                     .monthsOfYear("January")
 *                                     .retentionDuration(RetentionDurationArgs.builder()
 *                                         .count(10)
 *                                         .durationType("Years")
 *                                         .build())
 *                                     .retentionScheduleFormatType("Weekly")
 *                                     .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                                         .daysOfTheWeek("Sunday")
 *                                         .weeksOfTheMonth("First")
 *                                         .build())
 *                                     .retentionTimes("2022-11-29T19:30:00.000Z")
 *                                     .build())
 *                                 .build())
 *                             .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                                 .schedulePolicyType("SimpleSchedulePolicy")
 *                                 .scheduleRunDays("Sunday")
 *                                 .scheduleRunFrequency("Weekly")
 *                                 .scheduleRunTimes("2022-11-29T19:30:00.000Z")
 *                                 .build())
 *                             .tieringPolicy(Map.of("ArchivedRP", Map.ofEntries(
 *                                 Map.entry("duration", 45),
 *                                 Map.entry("durationType", "Days"),
 *                                 Map.entry("tieringMode", "TierAfter")
 *                             )))
 *                             .build(),
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Differential")
 *                             .retentionPolicy(SimpleRetentionPolicyArgs.builder()
 *                                 .retentionDuration(RetentionDurationArgs.builder()
 *                                     .count(30)
 *                                     .durationType("Days")
 *                                     .build())
 *                                 .retentionPolicyType("SimpleRetentionPolicy")
 *                                 .build())
 *                             .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                                 .schedulePolicyType("SimpleSchedulePolicy")
 *                                 .scheduleRunDays("Monday")
 *                                 .scheduleRunFrequency("Weekly")
 *                                 .scheduleRunTimes("2022-09-29T02:00:00Z")
 *                                 .scheduleWeeklyFrequency(0)
 *                                 .build())
 *                             .build(),
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Log")
 *                             .retentionPolicy(SimpleRetentionPolicyArgs.builder()
 *                                 .retentionDuration(RetentionDurationArgs.builder()
 *                                     .count(20)
 *                                     .durationType("Days")
 *                                     .build())
 *                                 .retentionPolicyType("SimpleRetentionPolicy")
 *                                 .build())
 *                             .schedulePolicy(LogSchedulePolicyArgs.builder()
 *                                 .scheduleFrequencyInMins(120)
 *                                 .schedulePolicyType("LogSchedulePolicy")
 *                                 .build())
 *                             .build())
 *                     .workLoadType("SQLDataBase")
 *                     .build())
 *                 .backupType("SQL")
 *                 .recoveryServicesVault(NewRecoveryServicesVaultArgs.builder()
 *                     .name("test-vault")
 *                     .resourceGroup("test-rg")
 *                     .vaultType("New")
 *                     .build())
 *                 .build())
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM backup connection with a new backup policy with tieringPolicy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.VMBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.VMBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureIaasVM",
 *                 InstantRPDetails = new AzureNative.Workloads.Inputs.InstantRPAdditionalDetailsArgs
 *                 {
 *                     AzureBackupRGNamePrefix = "dasas",
 *                     AzureBackupRGNameSuffix = "a",
 *                 },
 *                 InstantRpRetentionRangeInDays = 2,
 *                 Name = "defaultVmPolicy",
 *                 PolicyType = AzureNative.Workloads.IAASVMPolicyType.V1,
 *                 ProtectedItemsCount = 0,
 *                 RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                 {
 *                     DailySchedule = new AzureNative.Workloads.Inputs.DailyRetentionScheduleArgs
 *                     {
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 30,
 *                             DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                     MonthlySchedule = new AzureNative.Workloads.Inputs.MonthlyRetentionScheduleArgs
 *                     {
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 60,
 *                             DurationType = AzureNative.Workloads.RetentionDurationType.Months,
 *                         },
 *                         RetentionScheduleFormatType = AzureNative.Workloads.RetentionScheduleFormat.Weekly,
 *                         RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                         {
 *                             DaysOfTheWeek = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             WeeksOfTheMonth = new[]
 *                             {
 *                                 AzureNative.Workloads.WeekOfMonth.First,
 *                             },
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                     RetentionPolicyType = "LongTermRetentionPolicy",
 *                     WeeklySchedule = new AzureNative.Workloads.Inputs.WeeklyRetentionScheduleArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.Workloads.DayOfWeek.Sunday,
 *                         },
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 12,
 *                             DurationType = AzureNative.Workloads.RetentionDurationType.Weeks,
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                     YearlySchedule = new AzureNative.Workloads.Inputs.YearlyRetentionScheduleArgs
 *                     {
 *                         MonthsOfYear = new[]
 *                         {
 *                             AzureNative.Workloads.MonthOfYear.January,
 *                         },
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 10,
 *                             DurationType = AzureNative.Workloads.RetentionDurationType.Years,
 *                         },
 *                         RetentionScheduleFormatType = AzureNative.Workloads.RetentionScheduleFormat.Weekly,
 *                         RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                         {
 *                             DaysOfTheWeek = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             WeeksOfTheMonth = new[]
 *                             {
 *                                 AzureNative.Workloads.WeekOfMonth.First,
 *                             },
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                 },
 *                 SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                 {
 *                     SchedulePolicyType = "SimpleSchedulePolicy",
 *                     ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Daily,
 *                     ScheduleRunTimes = new[]
 *                     {
 *                         "2022-11-29T19:30:00.000Z",
 *                     },
 *                 },
 *                 TieringPolicy =
 *                 {
 *                     { "ArchivedRP", new AzureNative.Workloads.Inputs.TieringPolicyArgs
 *                     {
 *                         Duration = 3,
 *                         DurationType = AzureNative.Workloads.RetentionDurationType.Months,
 *                         TieringMode = AzureNative.Workloads.TieringMode.TierAfter,
 *                     } },
 *                 },
 *                 TimeZone = "UTC",
 *             },
 *             BackupType = "VM",
 *             DiskExclusionProperties = new AzureNative.Workloads.Inputs.DiskExclusionPropertiesArgs
 *             {
 *                 DiskLunList = new() { },
 *                 IsInclusionList = true,
 *             },
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *         },
 *         BackupName = "vmBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * BackupData: workloads.VMBackupData{
 * BackupPolicy: workloads.VMBackupPolicyProperties{
 * BackupManagementType: "AzureIaasVM",
 * InstantRPDetails: workloads.InstantRPAdditionalDetails{
 * AzureBackupRGNamePrefix: "dasas",
 * AzureBackupRGNameSuffix: "a",
 * },
 * InstantRpRetentionRangeInDays: 2,
 * Name: "defaultVmPolicy",
 * PolicyType: workloads.IAASVMPolicyTypeV1,
 * ProtectedItemsCount: 0,
 * RetentionPolicy: workloads.LongTermRetentionPolicy{
 * DailySchedule: workloads.DailyRetentionSchedule{
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 30,
 * DurationType: workloads.RetentionDurationTypeDays,
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * MonthlySchedule: workloads.MonthlyRetentionSchedule{
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 60,
 * DurationType: workloads.RetentionDurationTypeMonths,
 * },
 * RetentionScheduleFormatType: workloads.RetentionScheduleFormatWeekly,
 * RetentionScheduleWeekly: workloads.WeeklyRetentionFormat{
 * DaysOfTheWeek: []workloads.DayOfWeek{
 * workloads.DayOfWeekSunday,
 * },
 * WeeksOfTheMonth: []workloads.WeekOfMonth{
 * workloads.WeekOfMonthFirst,
 * },
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * RetentionPolicyType: "LongTermRetentionPolicy",
 * WeeklySchedule: workloads.WeeklyRetentionSchedule{
 * DaysOfTheWeek: []workloads.DayOfWeek{
 * workloads.DayOfWeekSunday,
 * },
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 12,
 * DurationType: workloads.RetentionDurationTypeWeeks,
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * YearlySchedule: workloads.YearlyRetentionSchedule{
 * MonthsOfYear: []workloads.MonthOfYear{
 * workloads.MonthOfYearJanuary,
 * },
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 10,
 * DurationType: workloads.RetentionDurationTypeYears,
 * },
 * RetentionScheduleFormatType: workloads.RetentionScheduleFormatWeekly,
 * RetentionScheduleWeekly: workloads.WeeklyRetentionFormat{
 * DaysOfTheWeek: []workloads.DayOfWeek{
 * workloads.DayOfWeekSunday,
 * },
 * WeeksOfTheMonth: []workloads.WeekOfMonth{
 * workloads.WeekOfMonthFirst,
 * },
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * },
 * SchedulePolicy: workloads.SimpleSchedulePolicy{
 * SchedulePolicyType: "SimpleSchedulePolicy",
 * ScheduleRunFrequency: workloads.ScheduleRunTypeDaily,
 * ScheduleRunTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * TieringPolicy: interface{}{
 * ArchivedRP: workloads.TieringPolicy{
 * Duration: 3,
 * DurationType: workloads.RetentionDurationTypeMonths,
 * TieringMode: workloads.TieringModeTierAfter,
 * },
 * },
 * TimeZone: "UTC",
 * },
 * BackupType: "VM",
 * DiskExclusionProperties: workloads.DiskExclusionProperties{
 * DiskLunList: []interface{}{
 * },
 * IsInclusionList: true,
 * },
 * RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * Name: "test-vault",
 * ResourceGroup: "test-rg",
 * VaultType: "New",
 * },
 * },
 * BackupName: pulumi.String("vmBackup"),
 * ConnectorName: pulumi.String("C1"),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(VMBackupDataArgs.builder()
 *                 .backupPolicy(VMBackupPolicyPropertiesArgs.builder()
 *                     .backupManagementType("AzureIaasVM")
 *                     .instantRPDetails(InstantRPAdditionalDetailsArgs.builder()
 *                         .azureBackupRGNamePrefix("dasas")
 *                         .azureBackupRGNameSuffix("a")
 *                         .build())
 *                     .instantRpRetentionRangeInDays(2)
 *                     .name("defaultVmPolicy")
 *                     .policyType("V1")
 *                     .protectedItemsCount(0)
 *                     .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                         .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                             .retentionDuration(RetentionDurationArgs.builder()
 *                                 .count(30)
 *                                 .durationType("Days")
 *                                 .build())
 *                             .retentionTimes("2022-11-29T19:30:00.000Z")
 *                             .build())
 *                         .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                             .retentionDuration(RetentionDurationArgs.builder()
 *                                 .count(60)
 *                                 .durationType("Months")
 *                                 .build())
 *                             .retentionScheduleFormatType("Weekly")
 *                             .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                                 .daysOfTheWeek("Sunday")
 *                                 .weeksOfTheMonth("First")
 *                                 .build())
 *                             .retentionTimes("2022-11-29T19:30:00.000Z")
 *                             .build())
 *                         .retentionPolicyType("LongTermRetentionPolicy")
 *                         .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .retentionDuration(RetentionDurationArgs.builder()
 *                                 .count(12)
 *                                 .durationType("Weeks")
 *                                 .build())
 *                             .retentionTimes("2022-11-29T19:30:00.000Z")
 *                             .build())
 *                         .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                             .monthsOfYear("January")
 *                             .retentionDuration(RetentionDurationArgs.builder()
 *                                 .count(10)
 *                                 .durationType("Years")
 *                                 .build())
 *                             .retentionScheduleFormatType("Weekly")
 *                             .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                                 .daysOfTheWeek("Sunday")
 *                                 .weeksOfTheMonth("First")
 *                                 .build())
 *                             .retentionTimes("2022-11-29T19:30:00.000Z")
 *                             .build())
 *                         .build())
 *                     .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                         .schedulePolicyType("SimpleSchedulePolicy")
 *                         .scheduleRunFrequency("Daily")
 *                         .scheduleRunTimes("2022-11-29T19:30:00.000Z")
 *                         .build())
 *                     .tieringPolicy(Map.of("ArchivedRP", Map.ofEntries(
 *                         Map.entry("duration", 3),
 *                         Map.entry("durationType", "Months"),
 *                         Map.entry("tieringMode", "TierAfter")
 *                     )))
 *                     .timeZone("UTC")
 *                     .build())
 *                 .backupType("VM")
 *                 .diskExclusionProperties(DiskExclusionPropertiesArgs.builder()
 *                     .diskLunList()
 *                     .isInclusionList(true)
 *                     .build())
 *                 .recoveryServicesVault(NewRecoveryServicesVaultArgs.builder()
 *                     .name("test-vault")
 *                     .resourceGroup("test-rg")
 *                     .vaultType("New")
 *                     .build())
 *                 .build())
 *             .backupName("vmBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a db backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.SqlBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultDbPolicy",
 *                 ProtectedItemsCount = 0,
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = false,
 *                     Issqlcompression = false,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Full,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                         {
 *                             DailySchedule = new AzureNative.Workloads.Inputs.DailyRetentionScheduleArgs
 *                             {
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 30,
 *                                     DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2018-01-10T18:30:00Z",
 *                                 },
 *                             },
 *                             RetentionPolicyType = "LongTermRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Daily,
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2018-01-10T18:30:00Z",
 *                             },
 *                             ScheduleWeeklyFrequency = 0,
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = AzureNative.Workloads.PolicyType.Log,
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 30,
 *                                 DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.LogSchedulePolicyArgs
 *                         {
 *                             ScheduleFrequencyInMins = 60,
 *                             SchedulePolicyType = "LogSchedulePolicy",
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = AzureNative.Workloads.WorkloadType.SQLDataBase,
 *             },
 *             BackupType = "SQL",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.ExistingRecoveryServicesVaultArgs
 *             {
 *                 Id = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 *                 VaultType = "Existing",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.SqlBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultDbPolicy",
 * 					ProtectedItemsCount:  0,
 * 					Settings: workloads.Settings{
 * 						IsCompression:    false,
 * 						Issqlcompression: false,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: workloads.PolicyTypeFull,
 * 							RetentionPolicy: {
 * 								DailySchedule: {
 * 									RetentionDuration: {
 * 										Count:        30,
 * 										DurationType: workloads.RetentionDurationTypeDays,
 * 									},
 * 									RetentionTimes: []string{
 * 										"2018-01-10T18:30:00Z",
 * 									},
 * 								},
 * 								RetentionPolicyType: "LongTermRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType:   "SimpleSchedulePolicy",
 * 								ScheduleRunFrequency: workloads.ScheduleRunTypeDaily,
 * 								ScheduleRunTimes: []string{
 * 									"2018-01-10T18:30:00Z",
 * 								},
 * 								ScheduleWeeklyFrequency: 0,
 * 							},
 * 						},
 * 						{
 * 							PolicyType: workloads.PolicyTypeLog,
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        30,
 * 									DurationType: workloads.RetentionDurationTypeDays,
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								ScheduleFrequencyInMins: 60,
 * 								SchedulePolicyType:      "LogSchedulePolicy",
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: workloads.WorkloadTypeSQLDataBase,
 * 				},
 * 				BackupType: "SQL",
 * 				RecoveryServicesVault: workloads.ExistingRecoveryServicesVault{
 * 					Id:        "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 * 					VaultType: "Existing",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(HanaBackupDataArgs.builder()
 *                 .backupPolicy(DBBackupPolicyPropertiesArgs.builder()
 *                     .backupManagementType("AzureWorkload")
 *                     .name("defaultDbPolicy")
 *                     .protectedItemsCount(0)
 *                     .settings(SettingsArgs.builder()
 *                         .isCompression(false)
 *                         .issqlcompression(false)
 *                         .timeZone("UTC")
 *                         .build())
 *                     .subProtectionPolicy(
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Full")
 *                             .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                                 .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                                     .retentionDuration(RetentionDurationArgs.builder()
 *                                         .count(30)
 *                                         .durationType("Days")
 *                                         .build())
 *                                     .retentionTimes("2018-01-10T18:30:00Z")
 *                                     .build())
 *                                 .retentionPolicyType("LongTermRetentionPolicy")
 *                                 .build())
 *                             .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                                 .schedulePolicyType("SimpleSchedulePolicy")
 *                                 .scheduleRunFrequency("Daily")
 *                                 .scheduleRunTimes("2018-01-10T18:30:00Z")
 *                                 .scheduleWeeklyFrequency(0)
 *                                 .build())
 *                             .build(),
 *                         SubProtectionPolicyArgs.builder()
 *                             .policyType("Log")
 *                             .retentionPolicy(SimpleRetentionPolicyArgs.builder()
 *                                 .retentionDuration(RetentionDurationArgs.builder()
 *                                     .count(30)
 *                                     .durationType("Days")
 *                                     .build())
 *                                 .retentionPolicyType("SimpleRetentionPolicy")
 *                                 .build())
 *                             .schedulePolicy(LogSchedulePolicyArgs.builder()
 *                                 .scheduleFrequencyInMins(60)
 *                                 .schedulePolicyType("LogSchedulePolicy")
 *                                 .build())
 *                             .build())
 *                     .workLoadType("SQLDataBase")
 *                     .build())
 *                 .backupType("SQL")
 *                 .recoveryServicesVault(ExistingRecoveryServicesVaultArgs.builder()
 *                     .id("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault")
 *                     .vaultType("Existing")
 *                     .build())
 *                 .build())
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a db backup connection with an existing backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.SqlBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 Name = "defaultDbPolicy",
 *             },
 *             BackupType = "SQL",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.ExistingRecoveryServicesVaultArgs
 *             {
 *                 Id = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 *                 VaultType = "Existing",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.SqlBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					Name: "defaultDbPolicy",
 * 				},
 * 				BackupType: "SQL",
 * 				RecoveryServicesVault: workloads.ExistingRecoveryServicesVault{
 * 					Id:        "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 * 					VaultType: "Existing",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(HanaBackupDataArgs.builder()
 *                 .backupPolicy(DBBackupPolicyPropertiesArgs.builder()
 *                     .name("defaultDbPolicy")
 *                     .build())
 *                 .backupType("SQL")
 *                 .recoveryServicesVault(ExistingRecoveryServicesVaultArgs.builder()
 *                     .id("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault")
 *                     .vaultType("Existing")
 *                     .build())
 *                 .build())
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.VMBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.VMBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureIaasVM",
 *                 InstantRPDetails = null,
 *                 InstantRpRetentionRangeInDays = 2,
 *                 Name = "defaultVmPolicy",
 *                 ProtectedItemsCount = 0,
 *                 RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                 {
 *                     DailySchedule = new AzureNative.Workloads.Inputs.DailyRetentionScheduleArgs
 *                     {
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 30,
 *                             DurationType = AzureNative.Workloads.RetentionDurationType.Days,
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2018-01-10T18:30:00Z",
 *                         },
 *                     },
 *                     RetentionPolicyType = "LongTermRetentionPolicy",
 *                 },
 *                 SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                 {
 *                     SchedulePolicyType = "SimpleSchedulePolicy",
 *                     ScheduleRunFrequency = AzureNative.Workloads.ScheduleRunType.Daily,
 *                     ScheduleRunTimes = new[]
 *                     {
 *                         "2018-01-10T18:30:00Z",
 *                     },
 *                     ScheduleWeeklyFrequency = 0,
 *                 },
 *             },
 *             BackupType = "VM",
 *             DiskExclusionProperties = new AzureNative.Workloads.Inputs.DiskExclusionPropertiesArgs
 *             {
 *                 DiskLunList = new() { },
 *                 IsInclusionList = true,
 *             },
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *         },
 *         BackupName = "vmBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.VMBackupData{
 * 				BackupPolicy: workloads.VMBackupPolicyProperties{
 * 					BackupManagementType:          "AzureIaasVM",
 * 					InstantRPDetails:              nil,
 * 					InstantRpRetentionRangeInDays: 2,
 * 					Name:                          "defaultVmPolicy",
 * 					ProtectedItemsCount:           0,
 * 					RetentionPolicy: workloads.LongTermRetentionPolicy{
 * 						DailySchedule: workloads.DailyRetentionSchedule{
 * 							RetentionDuration: workloads.RetentionDuration{
 * 								Count:        30,
 * 								DurationType: workloads.RetentionDurationTypeDays,
 * 							},
 * 							RetentionTimes: []string{
 * 								"2018-01-10T18:30:00Z",
 * 							},
 * 						},
 * 						RetentionPolicyType: "LongTermRetentionPolicy",
 * 					},
 * 					SchedulePolicy: workloads.SimpleSchedulePolicy{
 * 						SchedulePolicyType:   "SimpleSchedulePolicy",
 * 						ScheduleRunFrequency: workloads.ScheduleRunTypeDaily,
 * 						ScheduleRunTimes: []string{
 * 							"2018-01-10T18:30:00Z",
 * 						},
 * 						ScheduleWeeklyFrequency: 0,
 * 					},
 * 				},
 * 				BackupType: "VM",
 * 				DiskExclusionProperties: workloads.DiskExclusionProperties{
 * 					DiskLunList:     []interface{}{},
 * 					IsInclusionList: true,
 * 				},
 * 				RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * 					Name:          "test-vault",
 * 					ResourceGroup: "test-rg",
 * 					VaultType:     "New",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("vmBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(VMBackupDataArgs.builder()
 *                 .backupPolicy(VMBackupPolicyPropertiesArgs.builder()
 *                     .backupManagementType("AzureIaasVM")
 *                     .instantRPDetails()
 *                     .instantRpRetentionRangeInDays(2)
 *                     .name("defaultVmPolicy")
 *                     .protectedItemsCount(0)
 *                     .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                         .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                             .retentionDuration(RetentionDurationArgs.builder()
 *                                 .count(30)
 *                                 .durationType("Days")
 *                                 .build())
 *                             .retentionTimes("2018-01-10T18:30:00Z")
 *                             .build())
 *                         .retentionPolicyType("LongTermRetentionPolicy")
 *                         .build())
 *                     .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                         .schedulePolicyType("SimpleSchedulePolicy")
 *                         .scheduleRunFrequency("Daily")
 *                         .scheduleRunTimes("2018-01-10T18:30:00Z")
 *                         .scheduleWeeklyFrequency(0)
 *                         .build())
 *                     .build())
 *                 .backupType("VM")
 *                 .diskExclusionProperties(DiskExclusionPropertiesArgs.builder()
 *                     .diskLunList()
 *                     .isInclusionList(true)
 *                     .build())
 *                 .recoveryServicesVault(NewRecoveryServicesVaultArgs.builder()
 *                     .name("test-vault")
 *                     .resourceGroup("test-rg")
 *                     .vaultType("New")
 *                     .build())
 *                 .build())
 *             .backupName("vmBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm backup connection with an existing backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.VMBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.VMBackupPolicyPropertiesArgs
 *             {
 *                 Name = "defaultVmPolicy",
 *             },
 *             BackupType = "VM",
 *             DiskExclusionProperties = new AzureNative.Workloads.Inputs.DiskExclusionPropertiesArgs
 *             {
 *                 DiskLunList = new() { },
 *                 IsInclusionList = true,
 *             },
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.ExistingRecoveryServicesVaultArgs
 *             {
 *                 Id = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 *                 VaultType = "Existing",
 *             },
 *         },
 *         BackupName = "vmBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.VMBackupData{
 * 				BackupPolicy: workloads.VMBackupPolicyProperties{
 * 					Name: "defaultVmPolicy",
 * 				},
 * 				BackupType: "VM",
 * 				DiskExclusionProperties: workloads.DiskExclusionProperties{
 * 					DiskLunList:     []interface{}{},
 * 					IsInclusionList: true,
 * 				},
 * 				RecoveryServicesVault: workloads.ExistingRecoveryServicesVault{
 * 					Id:        "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 * 					VaultType: "Existing",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("vmBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(VMBackupDataArgs.builder()
 *                 .backupPolicy(VMBackupPolicyPropertiesArgs.builder()
 *                     .name("defaultVmPolicy")
 *                     .build())
 *                 .backupType("VM")
 *                 .diskExclusionProperties(DiskExclusionPropertiesArgs.builder()
 *                     .diskLunList()
 *                     .isInclusionList(true)
 *                     .build())
 *                 .recoveryServicesVault(ExistingRecoveryServicesVaultArgs.builder()
 *                     .id("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault")
 *                     .vaultType("Existing")
 *                     .build())
 *                 .build())
 *             .backupName("vmBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:ACSSBackupConnection db1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/connectors/{connectorName}/acssBackups/{backupName}
 * ```
 */
public class ACSSBackupConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.ACSSBackupConnection,
) : KotlinCustomResource(javaResource, ACSSBackupConnectionMapper) {
    /**
     * Information about the recovery services vault and backup policy used for backup.
     */
    public val backupData: Output<Any>?
        get() = javaResource.backupData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines the errors related to backup connection resource of virtual instance for SAP.
     */
    public val errors: Output<ConnectorErrorDefinitionResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorErrorDefinitionResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ACSSBackupConnectionMapper : ResourceMapper<ACSSBackupConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.ACSSBackupConnection::class == javaResource::class

    override fun map(javaResource: Resource): ACSSBackupConnection = ACSSBackupConnection(
        javaResource
            as com.pulumi.azurenative.workloads.ACSSBackupConnection,
    )
}

/**
 * @see [ACSSBackupConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ACSSBackupConnection].
 */
public suspend fun acssBackupConnection(
    name: String,
    block: suspend ACSSBackupConnectionResourceBuilder.() -> Unit,
): ACSSBackupConnection {
    val builder = ACSSBackupConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ACSSBackupConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun acssBackupConnection(name: String): ACSSBackupConnection {
    val builder = ACSSBackupConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
