@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.ConnectorArgs.builder
import com.pulumi.azurenative.workloads.kotlin.inputs.ManagedRGConfigurationArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.ManagedRGConfigurationArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.UserAssignedServiceIdentityArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.UserAssignedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the connector resource.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Create a connector resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.Workloads.Connector("connector", new()
 *     {
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SourceResourceId = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewConnector(ctx, "connector", &workloads.ConnectorArgs{
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SourceResourceId:  pulumi.String("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.Connector;
 * import com.pulumi.azurenative.workloads.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sourceResourceId("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:Connector C1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/connectors/{connectorName}
 * ```
 * @property connectorName The name of the connector resource
 * @property identity Managed service identity (user assigned identities)
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration Managed resource group configuration
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceResourceId Defines the ID of the connector's source resource.
 * @property tags Resource tags.
 */
public data class ConnectorArgs(
    public val connectorName: Output<String>? = null,
    public val identity: Output<UserAssignedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedRGConfigurationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.ConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.ConnectorArgs =
        com.pulumi.azurenative.workloads.ConnectorArgs.builder()
            .connectorName(connectorName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectorArgs].
 */
@PulumiTagMarker
public class ConnectorArgsBuilder internal constructor() {
    private var connectorName: Output<String>? = null

    private var identity: Output<UserAssignedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var managedResourceGroupConfiguration: Output<ManagedRGConfigurationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the connector resource
     */
    @JvmName("bgtirhiyipnvqxqu")
    public suspend fun connectorName(`value`: Output<String>) {
        this.connectorName = value
    }

    /**
     * @param value Managed service identity (user assigned identities)
     */
    @JvmName("jgqrffnksovvsvct")
    public suspend fun identity(`value`: Output<UserAssignedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xnlnwhwkgpbijtii")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Managed resource group configuration
     */
    @JvmName("ssaivflelxlturch")
    public suspend
    fun managedResourceGroupConfiguration(`value`: Output<ManagedRGConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rlvpmfvljjsnyrga")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Defines the ID of the connector's source resource.
     */
    @JvmName("xemgquohmtwqaedn")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wlegmyvnogtqdfjd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the connector resource
     */
    @JvmName("yelkuljsomjxfglw")
    public suspend fun connectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorName = mapped
    }

    /**
     * @param value Managed service identity (user assigned identities)
     */
    @JvmName("rvtbmhsmvcbjcqil")
    public suspend fun identity(`value`: UserAssignedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (user assigned identities)
     */
    @JvmName("erdghfiwtynrrypv")
    public suspend fun identity(argument: suspend UserAssignedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("npikldodxlobiqqk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Managed resource group configuration
     */
    @JvmName("rafvwljuvrybcbhu")
    public suspend fun managedResourceGroupConfiguration(`value`: ManagedRGConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument Managed resource group configuration
     */
    @JvmName("yuruxqifklldouls")
    public suspend
    fun managedResourceGroupConfiguration(argument: suspend ManagedRGConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedRGConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cuqyfkoivqwtsrly")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Defines the ID of the connector's source resource.
     */
    @JvmName("lqmdvspadpwkjxek")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("keqthlheswyoerji")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("buvyyjywghohcuqp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectorArgs = ConnectorArgs(
        connectorName = connectorName,
        identity = identity,
        location = location,
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        resourceGroupName = resourceGroupName,
        sourceResourceId = sourceResourceId,
        tags = tags,
    )
}
