@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.MonitorPropertiesResponseErrors
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse.Companion.toKotlin as managedRGConfigurationResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.MonitorPropertiesResponseErrors.Companion.toKotlin as monitorPropertiesResponseErrorsToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin as userAssignedServiceIdentityResponseToKotlin

/**
 * Builder for [Monitor].
 */
@PulumiTagMarker
public class MonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitorArgs = MonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitorArgsBuilder.() -> Unit) {
        val builder = MonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Monitor {
        val builtJavaResource = com.pulumi.azurenative.workloads.Monitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Monitor(builtJavaResource)
    }
}

/**
 * SAP monitor info on Azure (ARM properties and SAP monitor properties)
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### Create a SAP monitor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitor = new AzureNative.Workloads.Monitor("monitor", new()
 *     {
 *         AppLocation = "westus",
 *         Location = "westus",
 *         LogAnalyticsWorkspaceArmId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace",
 *         ManagedResourceGroupConfiguration = new AzureNative.Workloads.Inputs.ManagedRGConfigurationArgs
 *         {
 *             Name = "myManagedRg",
 *         },
 *         MonitorName = "mySapMonitor",
 *         MonitorSubnet = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         ResourceGroupName = "myResourceGroup",
 *         RoutingPreference = AzureNative.Workloads.RoutingPreference.RouteAll,
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewMonitor(ctx, "monitor", &workloads.MonitorArgs{
 * 			AppLocation:                pulumi.String("westus"),
 * 			Location:                   pulumi.String("westus"),
 * 			LogAnalyticsWorkspaceArmId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace"),
 * 			ManagedResourceGroupConfiguration: &workloads.ManagedRGConfigurationArgs{
 * 				Name: pulumi.String("myManagedRg"),
 * 			},
 * 			MonitorName:       pulumi.String("mySapMonitor"),
 * 			MonitorSubnet:     pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RoutingPreference: pulumi.String(workloads.RoutingPreferenceRouteAll),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.Monitor;
 * import com.pulumi.azurenative.workloads.MonitorArgs;
 * import com.pulumi.azurenative.workloads.inputs.ManagedRGConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitor = new Monitor("monitor", MonitorArgs.builder()
 *             .appLocation("westus")
 *             .location("westus")
 *             .logAnalyticsWorkspaceArmId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace")
 *             .managedResourceGroupConfiguration(ManagedRGConfigurationArgs.builder()
 *                 .name("myManagedRg")
 *                 .build())
 *             .monitorName("mySapMonitor")
 *             .monitorSubnet("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet")
 *             .resourceGroupName("myResourceGroup")
 *             .routingPreference("RouteAll")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:Monitor mySapMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/monitors/{monitorName}
 * ```
 */
public class Monitor internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.Monitor,
) : KotlinCustomResource(javaResource, MonitorMapper) {
    /**
     * The SAP monitor resources will be deployed in the SAP monitoring region. The subnet region should be same as the SAP monitoring region.
     */
    public val appLocation: Output<String>?
        get() = javaResource.appLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines the SAP monitor errors.
     */
    public val errors: Output<MonitorPropertiesResponseErrors>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                monitorPropertiesResponseErrorsToKotlin(args0)
            })
        })

    /**
     * [currently not in use] Managed service identity(user assigned identities)
     */
    public val identity: Output<UserAssignedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userAssignedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The ARM ID of the Log Analytics Workspace that is used for SAP monitoring.
     */
    public val logAnalyticsWorkspaceArmId: Output<String>?
        get() = javaResource.logAnalyticsWorkspaceArmId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Managed resource group configuration
     */
    public val managedResourceGroupConfiguration: Output<ManagedRGConfigurationResponse>?
        get() = javaResource.managedResourceGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedRGConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The subnet which the SAP monitor will be deployed in
     */
    public val monitorSubnet: Output<String>?
        get() = javaResource.monitorSubnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARM ID of the MSI used for SAP monitoring.
     */
    public val msiArmId: Output<String>
        get() = javaResource.msiArmId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of provisioning of the SAP monitor.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
     */
    public val routingPreference: Output<String>?
        get() = javaResource.routingPreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARM ID of the Storage account used for SAP monitoring.
     */
    public val storageAccountArmId: Output<String>
        get() = javaResource.storageAccountArmId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Sets the preference for zone redundancy on resources created for the SAP monitor. By default resources will be created which do not support zone redundancy.
     */
    public val zoneRedundancyPreference: Output<String>?
        get() = javaResource.zoneRedundancyPreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MonitorMapper : ResourceMapper<Monitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.Monitor::class == javaResource::class

    override fun map(javaResource: Resource): Monitor = Monitor(
        javaResource as
            com.pulumi.azurenative.workloads.Monitor,
    )
}

/**
 * @see [Monitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Monitor].
 */
public suspend fun monitor(name: String, block: suspend MonitorResourceBuilder.() -> Unit):
    Monitor {
    val builder = MonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Monitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitor(name: String): Monitor {
    val builder = MonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
