@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.SAPCentralInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the SAP Central Services Instance resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create SAP Central Instances for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapCentralInstance = new AzureNative.Workloads.SAPCentralInstance("sapCentralInstance", new()
 *     {
 *         CentralInstanceName = "centralServer",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPCentralInstance(ctx, "sapCentralInstance", &workloads.SAPCentralInstanceArgs{
 * 			CentralInstanceName:    pulumi.String("centralServer"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPCentralInstance;
 * import com.pulumi.azurenative.workloads.SAPCentralInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapCentralInstance = new SAPCentralInstance("sapCentralInstance", SAPCentralInstanceArgs.builder()
 *             .centralInstanceName("centralServer")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### SAPCentralInstances_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapCentralInstance = new AzureNative.Workloads.SAPCentralInstance("sapCentralInstance", new()
 *     {
 *         CentralInstanceName = "centralServer",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPCentralInstance(ctx, "sapCentralInstance", &workloads.SAPCentralInstanceArgs{
 * 			CentralInstanceName:    pulumi.String("centralServer"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPCentralInstance;
 * import com.pulumi.azurenative.workloads.SAPCentralInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapCentralInstance = new SAPCentralInstance("sapCentralInstance", SAPCentralInstanceArgs.builder()
 *             .centralInstanceName("centralServer")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SAPCentralInstance centralServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/centralInstances/{centralInstanceName}
 * ```
 * @property centralInstanceName Central Services Instance resource name string modeled as parameter for auto generation to work correctly.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
 * @property tags Resource tags.
 */
public data class SAPCentralInstanceArgs(
    public val centralInstanceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sapVirtualInstanceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.SAPCentralInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.SAPCentralInstanceArgs =
        com.pulumi.azurenative.workloads.SAPCentralInstanceArgs.builder()
            .centralInstanceName(centralInstanceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sapVirtualInstanceName(sapVirtualInstanceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SAPCentralInstanceArgs].
 */
@PulumiTagMarker
public class SAPCentralInstanceArgsBuilder internal constructor() {
    private var centralInstanceName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sapVirtualInstanceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Central Services Instance resource name string modeled as parameter for auto generation to work correctly.
     */
    @JvmName("xwmlmqkrwvumvpco")
    public suspend fun centralInstanceName(`value`: Output<String>) {
        this.centralInstanceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vqknpbmcftfqejyi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ndawhvxothdntwqe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Virtual Instances for SAP solutions resource
     */
    @JvmName("hacrgdodeowlkewy")
    public suspend fun sapVirtualInstanceName(`value`: Output<String>) {
        this.sapVirtualInstanceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iuuqcguyxyrfujre")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Central Services Instance resource name string modeled as parameter for auto generation to work correctly.
     */
    @JvmName("fnpcrbanodgqemsv")
    public suspend fun centralInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.centralInstanceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gpdnvwfjphxiwvfh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vavjyruykbehdiim")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Instances for SAP solutions resource
     */
    @JvmName("jmtjohltouilfdsu")
    public suspend fun sapVirtualInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapVirtualInstanceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wkvdvqbwjknhlmjo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ogjfohhbgjaqdjal")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SAPCentralInstanceArgs = SAPCentralInstanceArgs(
        centralInstanceName = centralInstanceName,
        location = location,
        resourceGroupName = resourceGroupName,
        sapVirtualInstanceName = sapVirtualInstanceName,
        tags = tags,
    )
}
