@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.DatabaseVmDetailsResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.DatabaseVmDetailsResponse.Companion.toKotlin as databaseVmDetailsResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse.Companion.toKotlin as loadBalancerDetailsResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin as sAPVirtualInstanceErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SAPDatabaseInstance].
 */
@PulumiTagMarker
public class SAPDatabaseInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SAPDatabaseInstanceArgs = SAPDatabaseInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SAPDatabaseInstanceArgsBuilder.() -> Unit) {
        val builder = SAPDatabaseInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SAPDatabaseInstance {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.SAPDatabaseInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SAPDatabaseInstance(builtJavaResource)
    }
}

/**
 * Define the Database resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create SAP Database Instances for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapDatabaseInstance = new AzureNative.Workloads.SAPDatabaseInstance("sapDatabaseInstance", new()
 *     {
 *         DatabaseInstanceName = "databaseServer",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPDatabaseInstance(ctx, "sapDatabaseInstance", &workloads.SAPDatabaseInstanceArgs{
 * 			DatabaseInstanceName:   pulumi.String("databaseServer"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPDatabaseInstance;
 * import com.pulumi.azurenative.workloads.SAPDatabaseInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapDatabaseInstance = new SAPDatabaseInstance("sapDatabaseInstance", SAPDatabaseInstanceArgs.builder()
 *             .databaseInstanceName("databaseServer")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### SAPDatabaseInstances_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapDatabaseInstance = new AzureNative.Workloads.SAPDatabaseInstance("sapDatabaseInstance", new()
 *     {
 *         DatabaseInstanceName = "databaseServer",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPDatabaseInstance(ctx, "sapDatabaseInstance", &workloads.SAPDatabaseInstanceArgs{
 * 			DatabaseInstanceName:   pulumi.String("databaseServer"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPDatabaseInstance;
 * import com.pulumi.azurenative.workloads.SAPDatabaseInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapDatabaseInstance = new SAPDatabaseInstance("sapDatabaseInstance", SAPDatabaseInstanceArgs.builder()
 *             .databaseInstanceName("databaseServer")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SAPDatabaseInstance databaseServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/databaseInstances/{databaseInstanceName}
 * ```
 */
public class SAPDatabaseInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SAPDatabaseInstance,
) : KotlinCustomResource(javaResource, SAPDatabaseInstanceMapper) {
    /**
     * Database SID name.
     */
    public val databaseSid: Output<String>
        get() = javaResource.databaseSid().applyValue({ args0 -> args0 })

    /**
     * Database type, that is if the DB is HANA, DB2, Oracle, SAP ASE, Max DB or MS SQL Server.
     */
    public val databaseType: Output<String>
        get() = javaResource.databaseType().applyValue({ args0 -> args0 })

    /**
     * Defines the errors related to Database resource.
     */
    public val errors: Output<SAPVirtualInstanceErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPVirtualInstanceErrorResponseToKotlin(args0)
            })
        })

    /**
     * Database IP Address.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The Load Balancer details such as LoadBalancer ID attached to Database Virtual Machines
     */
    public val loadBalancerDetails: Output<LoadBalancerDetailsResponse>
        get() = javaResource.loadBalancerDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Database subnet.
     */
    public val subnet: Output<String>
        get() = javaResource.subnet().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of virtual machines corresponding to the Database resource.
     */
    public val vmDetails: Output<List<DatabaseVmDetailsResponse>>
        get() = javaResource.vmDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    databaseVmDetailsResponseToKotlin(args0)
                })
            })
        })
}

public object SAPDatabaseInstanceMapper : ResourceMapper<SAPDatabaseInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SAPDatabaseInstance::class == javaResource::class

    override fun map(javaResource: Resource): SAPDatabaseInstance = SAPDatabaseInstance(
        javaResource
            as com.pulumi.azurenative.workloads.SAPDatabaseInstance,
    )
}

/**
 * @see [SAPDatabaseInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SAPDatabaseInstance].
 */
public suspend fun sapDatabaseInstance(
    name: String,
    block: suspend SAPDatabaseInstanceResourceBuilder.() -> Unit,
): SAPDatabaseInstance {
    val builder = SAPDatabaseInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SAPDatabaseInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapDatabaseInstance(name: String): SAPDatabaseInstance {
    val builder = SAPDatabaseInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
