@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse.Companion.toKotlin as sAPMigrateErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SapDiscoverySite].
 */
@PulumiTagMarker
public class SapDiscoverySiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SapDiscoverySiteArgs = SapDiscoverySiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SapDiscoverySiteArgsBuilder.() -> Unit) {
        val builder = SapDiscoverySiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SapDiscoverySite {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.SapDiscoverySite(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SapDiscoverySite(builtJavaResource)
    }
}

/**
 * Define the SAP Migration discovery site resource.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Create resource for Import based input.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapDiscoverySite = new AzureNative.Workloads.SapDiscoverySite("sapDiscoverySite", new()
 *     {
 *         Location = "eastus",
 *         MasterSiteId = "MasterSiteIdResourceId",
 *         MigrateProjectId = "MigrateProjectId",
 *         ResourceGroupName = "test-rg",
 *         SapDiscoverySiteName = "SampleSite",
 *         Tags =
 *         {
 *             { "property1", "value1" },
 *             { "property2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSapDiscoverySite(ctx, "sapDiscoverySite", &workloads.SapDiscoverySiteArgs{
 * 			Location:             pulumi.String("eastus"),
 * 			MasterSiteId:         pulumi.String("MasterSiteIdResourceId"),
 * 			MigrateProjectId:     pulumi.String("MigrateProjectId"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			SapDiscoverySiteName: pulumi.String("SampleSite"),
 * 			Tags: pulumi.StringMap{
 * 				"property1": pulumi.String("value1"),
 * 				"property2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SapDiscoverySite;
 * import com.pulumi.azurenative.workloads.SapDiscoverySiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapDiscoverySite = new SapDiscoverySite("sapDiscoverySite", SapDiscoverySiteArgs.builder()
 *             .location("eastus")
 *             .masterSiteId("MasterSiteIdResourceId")
 *             .migrateProjectId("MigrateProjectId")
 *             .resourceGroupName("test-rg")
 *             .sapDiscoverySiteName("SampleSite")
 *             .tags(Map.ofEntries(
 *                 Map.entry("property1", "value1"),
 *                 Map.entry("property2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SapDiscoverySite SampleSite /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}
 * ```
 */
public class SapDiscoverySite internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SapDiscoverySite,
) : KotlinCustomResource(javaResource, SapDiscoverySiteMapper) {
    /**
     * Indicates any errors on the SAP Migration discovery site resource.
     */
    public val errors: Output<SAPMigrateErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPMigrateErrorResponseToKotlin(args0)
            })
        })

    /**
     * The extended location definition.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The master site ID from Azure Migrate.
     */
    public val masterSiteId: Output<String>?
        get() = javaResource.masterSiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The migrate project ID from Azure Migrate.
     */
    public val migrateProjectId: Output<String>?
        get() = javaResource.migrateProjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SapDiscoverySiteMapper : ResourceMapper<SapDiscoverySite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SapDiscoverySite::class == javaResource::class

    override fun map(javaResource: Resource): SapDiscoverySite = SapDiscoverySite(
        javaResource as
            com.pulumi.azurenative.workloads.SapDiscoverySite,
    )
}

/**
 * @see [SapDiscoverySite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SapDiscoverySite].
 */
public suspend fun sapDiscoverySite(
    name: String,
    block: suspend SapDiscoverySiteResourceBuilder.() -> Unit,
): SapDiscoverySite {
    val builder = SapDiscoverySiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SapDiscoverySite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapDiscoverySite(name: String): SapDiscoverySite {
    val builder = SapDiscoverySiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
