@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.SapInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the SAP Instance resource.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Creates the SAP Instance resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapInstance = new AzureNative.Workloads.SapInstance("sapInstance", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "test-rg",
 *         SapDiscoverySiteName = "SampleSite",
 *         SapInstanceName = "MPP_MPP",
 *         Tags =
 *         {
 *             { "property1", "value1" },
 *             { "property2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSapInstance(ctx, "sapInstance", &workloads.SapInstanceArgs{
 * 			Location:             pulumi.String("eastus"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			SapDiscoverySiteName: pulumi.String("SampleSite"),
 * 			SapInstanceName:      pulumi.String("MPP_MPP"),
 * 			Tags: pulumi.StringMap{
 * 				"property1": pulumi.String("value1"),
 * 				"property2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SapInstance;
 * import com.pulumi.azurenative.workloads.SapInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapInstance = new SapInstance("sapInstance", SapInstanceArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("test-rg")
 *             .sapDiscoverySiteName("SampleSite")
 *             .sapInstanceName("MPP_MPP")
 *             .tags(Map.ofEntries(
 *                 Map.entry("property1", "value1"),
 *                 Map.entry("property2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SapInstance MPP_MPP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapDiscoverySiteName The name of the discovery site resource for SAP Migration.
 * @property sapInstanceName The name of SAP Instance resource for SAP Migration.
 * @property tags Resource tags.
 */
public data class SapInstanceArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sapDiscoverySiteName: Output<String>? = null,
    public val sapInstanceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.SapInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.SapInstanceArgs =
        com.pulumi.azurenative.workloads.SapInstanceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sapDiscoverySiteName(sapDiscoverySiteName?.applyValue({ args0 -> args0 }))
            .sapInstanceName(sapInstanceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SapInstanceArgs].
 */
@PulumiTagMarker
public class SapInstanceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sapDiscoverySiteName: Output<String>? = null

    private var sapInstanceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tkohisbshfwsjkit")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mqdccclssgweyhjh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("ioijbfensnfamuru")
    public suspend fun sapDiscoverySiteName(`value`: Output<String>) {
        this.sapDiscoverySiteName = value
    }

    /**
     * @param value The name of SAP Instance resource for SAP Migration.
     */
    @JvmName("obnqlrafuxsqbdtx")
    public suspend fun sapInstanceName(`value`: Output<String>) {
        this.sapInstanceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ndvixlysnlybebgh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ujdrjqdtoutfkeaw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jcwhrakxucbstnlw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("eppcrimhivekdosv")
    public suspend fun sapDiscoverySiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapDiscoverySiteName = mapped
    }

    /**
     * @param value The name of SAP Instance resource for SAP Migration.
     */
    @JvmName("btiohbovrnwecbyx")
    public suspend fun sapInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapInstanceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aftjofvveavwoppm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("panongrldarmqink")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SapInstanceArgs = SapInstanceArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        sapDiscoverySiteName = sapDiscoverySiteName,
        sapInstanceName = sapInstanceName,
        tags = tags,
    )
}
