@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorMetricThresholdsResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorPropertiesResponseGrouping
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorMetricThresholdsResponse.Companion.toKotlin as sapLandscapeMonitorMetricThresholdsResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorPropertiesResponseGrouping.Companion.toKotlin as sapLandscapeMonitorPropertiesResponseGroupingToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SapLandscapeMonitor].
 */
@PulumiTagMarker
public class SapLandscapeMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SapLandscapeMonitorArgs = SapLandscapeMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SapLandscapeMonitorArgsBuilder.() -> Unit) {
        val builder = SapLandscapeMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SapLandscapeMonitor {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.SapLandscapeMonitor(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SapLandscapeMonitor(builtJavaResource)
    }
}

/**
 * configuration associated with SAP Landscape Monitor Dashboard.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create for SAP Landscape monitor Dashboard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapLandscapeMonitor = new AzureNative.Workloads.SapLandscapeMonitor("sapLandscapeMonitor", new()
 *     {
 *         Grouping = new AzureNative.Workloads.Inputs.SapLandscapeMonitorPropertiesGroupingArgs
 *         {
 *             Landscape = new[]
 *             {
 *                 new AzureNative.Workloads.Inputs.SapLandscapeMonitorSidMappingArgs
 *                 {
 *                     Name = "Prod",
 *                     TopSid = new[]
 *                     {
 *                         "SID1",
 *                         "SID2",
 *                     },
 *                 },
 *             },
 *             SapApplication = new[]
 *             {
 *                 new AzureNative.Workloads.Inputs.SapLandscapeMonitorSidMappingArgs
 *                 {
 *                     Name = "ERP1",
 *                     TopSid = new[]
 *                     {
 *                         "SID1",
 *                         "SID2",
 *                     },
 *                 },
 *             },
 *         },
 *         MonitorName = "mySapMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         TopMetricsThresholds = new[]
 *         {
 *             new AzureNative.Workloads.Inputs.SapLandscapeMonitorMetricThresholdsArgs
 *             {
 *                 Green = 90,
 *                 Name = "Instance Availability",
 *                 Red = 50,
 *                 Yellow = 75,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSapLandscapeMonitor(ctx, "sapLandscapeMonitor", &workloads.SapLandscapeMonitorArgs{
 * 			Grouping: &workloads.SapLandscapeMonitorPropertiesGroupingArgs{
 * 				Landscape: workloads.SapLandscapeMonitorSidMappingArray{
 * 					&workloads.SapLandscapeMonitorSidMappingArgs{
 * 						Name: pulumi.String("Prod"),
 * 						TopSid: pulumi.StringArray{
 * 							pulumi.String("SID1"),
 * 							pulumi.String("SID2"),
 * 						},
 * 					},
 * 				},
 * 				SapApplication: workloads.SapLandscapeMonitorSidMappingArray{
 * 					&workloads.SapLandscapeMonitorSidMappingArgs{
 * 						Name: pulumi.String("ERP1"),
 * 						TopSid: pulumi.StringArray{
 * 							pulumi.String("SID1"),
 * 							pulumi.String("SID2"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			MonitorName:       pulumi.String("mySapMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			TopMetricsThresholds: workloads.SapLandscapeMonitorMetricThresholdsArray{
 * 				&workloads.SapLandscapeMonitorMetricThresholdsArgs{
 * 					Green:  pulumi.Float64(90),
 * 					Name:   pulumi.String("Instance Availability"),
 * 					Red:    pulumi.Float64(50),
 * 					Yellow: pulumi.Float64(75),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SapLandscapeMonitor;
 * import com.pulumi.azurenative.workloads.SapLandscapeMonitorArgs;
 * import com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorPropertiesGroupingArgs;
 * import com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorMetricThresholdsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapLandscapeMonitor = new SapLandscapeMonitor("sapLandscapeMonitor", SapLandscapeMonitorArgs.builder()
 *             .grouping(SapLandscapeMonitorPropertiesGroupingArgs.builder()
 *                 .landscape(SapLandscapeMonitorSidMappingArgs.builder()
 *                     .name("Prod")
 *                     .topSid(
 *                         "SID1",
 *                         "SID2")
 *                     .build())
 *                 .sapApplication(SapLandscapeMonitorSidMappingArgs.builder()
 *                     .name("ERP1")
 *                     .topSid(
 *                         "SID1",
 *                         "SID2")
 *                     .build())
 *                 .build())
 *             .monitorName("mySapMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .topMetricsThresholds(SapLandscapeMonitorMetricThresholdsArgs.builder()
 *                 .green(90)
 *                 .name("Instance Availability")
 *                 .red(50)
 *                 .yellow(75)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SapLandscapeMonitor default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/monitors/{monitorName}/sapLandscapeMonitor/default
 * ```
 */
public class SapLandscapeMonitor internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SapLandscapeMonitor,
) : KotlinCustomResource(javaResource, SapLandscapeMonitorMapper) {
    /**
     * Gets or sets the SID groupings by landscape and Environment.
     */
    public val grouping: Output<SapLandscapeMonitorPropertiesResponseGrouping>?
        get() = javaResource.grouping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sapLandscapeMonitorPropertiesResponseGroupingToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of provisioning of the SAP monitor.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    public val topMetricsThresholds: Output<List<SapLandscapeMonitorMetricThresholdsResponse>>?
        get() = javaResource.topMetricsThresholds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        sapLandscapeMonitorMetricThresholdsResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SapLandscapeMonitorMapper : ResourceMapper<SapLandscapeMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SapLandscapeMonitor::class == javaResource::class

    override fun map(javaResource: Resource): SapLandscapeMonitor = SapLandscapeMonitor(
        javaResource
            as com.pulumi.azurenative.workloads.SapLandscapeMonitor,
    )
}

/**
 * @see [SapLandscapeMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SapLandscapeMonitor].
 */
public suspend fun sapLandscapeMonitor(
    name: String,
    block: suspend SapLandscapeMonitorResourceBuilder.() -> Unit,
): SapLandscapeMonitor {
    val builder = SapLandscapeMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SapLandscapeMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapLandscapeMonitor(name: String): SapLandscapeMonitor {
    val builder = SapLandscapeMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
