@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.ServerInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Define the Server Instance resource.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Creates the Server Instance resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverInstance = new AzureNative.Workloads.ServerInstance("serverInstance", new()
 *     {
 *         ResourceGroupName = "test-rg",
 *         SapDiscoverySiteName = "SampleSite",
 *         SapInstanceName = "MPP_MPP",
 *         ServerInstanceName = "APP_SapServer1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewServerInstance(ctx, "serverInstance", &workloads.ServerInstanceArgs{
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			SapDiscoverySiteName: pulumi.String("SampleSite"),
 * 			SapInstanceName:      pulumi.String("MPP_MPP"),
 * 			ServerInstanceName:   pulumi.String("APP_SapServer1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ServerInstance;
 * import com.pulumi.azurenative.workloads.ServerInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverInstance = new ServerInstance("serverInstance", ServerInstanceArgs.builder()
 *             .resourceGroupName("test-rg")
 *             .sapDiscoverySiteName("SampleSite")
 *             .sapInstanceName("MPP_MPP")
 *             .serverInstanceName("APP_SapServer1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:ServerInstance APP_SapServer1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}/serverInstances/{serverInstanceName}
 * ```
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapDiscoverySiteName The name of the discovery site resource for SAP Migration.
 * @property sapInstanceName The name of SAP Instance resource for SAP Migration.
 * @property serverInstanceName The name of the Server instance resource for SAP Migration.
 */
public data class ServerInstanceArgs(
    public val resourceGroupName: Output<String>? = null,
    public val sapDiscoverySiteName: Output<String>? = null,
    public val sapInstanceName: Output<String>? = null,
    public val serverInstanceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.ServerInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.ServerInstanceArgs =
        com.pulumi.azurenative.workloads.ServerInstanceArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sapDiscoverySiteName(sapDiscoverySiteName?.applyValue({ args0 -> args0 }))
            .sapInstanceName(sapInstanceName?.applyValue({ args0 -> args0 }))
            .serverInstanceName(serverInstanceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerInstanceArgs].
 */
@PulumiTagMarker
public class ServerInstanceArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var sapDiscoverySiteName: Output<String>? = null

    private var sapInstanceName: Output<String>? = null

    private var serverInstanceName: Output<String>? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lqhafwymrittfwva")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("cwtiushotxmkmjys")
    public suspend fun sapDiscoverySiteName(`value`: Output<String>) {
        this.sapDiscoverySiteName = value
    }

    /**
     * @param value The name of SAP Instance resource for SAP Migration.
     */
    @JvmName("kqgjvwxkmpummhrk")
    public suspend fun sapInstanceName(`value`: Output<String>) {
        this.sapInstanceName = value
    }

    /**
     * @param value The name of the Server instance resource for SAP Migration.
     */
    @JvmName("hsdrrvjgqsyeprey")
    public suspend fun serverInstanceName(`value`: Output<String>) {
        this.serverInstanceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cxwothhembgnbvus")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("vvlgwfiocuyydrbx")
    public suspend fun sapDiscoverySiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapDiscoverySiteName = mapped
    }

    /**
     * @param value The name of SAP Instance resource for SAP Migration.
     */
    @JvmName("rlmvqjgnetciytty")
    public suspend fun sapInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapInstanceName = mapped
    }

    /**
     * @param value The name of the Server instance resource for SAP Migration.
     */
    @JvmName("nuontyxcwxrkklqk")
    public suspend fun serverInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverInstanceName = mapped
    }

    internal fun build(): ServerInstanceArgs = ServerInstanceArgs(
        resourceGroupName = resourceGroupName,
        sapDiscoverySiteName = sapDiscoverySiteName,
        sapInstanceName = sapInstanceName,
        serverInstanceName = serverInstanceName,
    )
}
