@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the disk sku name.
 */
public enum class DiskSkuName(
    public val javaValue: com.pulumi.azurenative.workloads.enums.DiskSkuName,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.DiskSkuName> {
    Standard_LRS(com.pulumi.azurenative.workloads.enums.DiskSkuName.Standard_LRS),
    Premium_LRS(com.pulumi.azurenative.workloads.enums.DiskSkuName.Premium_LRS),
    StandardSSD_LRS(com.pulumi.azurenative.workloads.enums.DiskSkuName.StandardSSD_LRS),
    UltraSSD_LRS(com.pulumi.azurenative.workloads.enums.DiskSkuName.UltraSSD_LRS),
    Premium_ZRS(com.pulumi.azurenative.workloads.enums.DiskSkuName.Premium_ZRS),
    StandardSSD_ZRS(com.pulumi.azurenative.workloads.enums.DiskSkuName.StandardSSD_ZRS),
    PremiumV2_LRS(com.pulumi.azurenative.workloads.enums.DiskSkuName.PremiumV2_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.DiskSkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.DiskSkuName): DiskSkuName =
            DiskSkuName.values().first { it.javaValue == javaType }
    }
}
