@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.ApplicationServerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Gets or sets the application server configuration.
 * @property instanceCount The number of app server instances.
 * @property subnetId The subnet id.
 * @property virtualMachineConfiguration Gets or sets the virtual machine configuration.
 */
public data class ApplicationServerConfigurationArgs(
    public val instanceCount: Output<Double>,
    public val subnetId: Output<String>,
    public val virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.ApplicationServerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.ApplicationServerConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.ApplicationServerConfigurationArgs.builder()
            .instanceCount(instanceCount.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 }))
            .virtualMachineConfiguration(
                virtualMachineConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationServerConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationServerConfigurationArgsBuilder internal constructor() {
    private var instanceCount: Output<Double>? = null

    private var subnetId: Output<String>? = null

    private var virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>? = null

    /**
     * @param value The number of app server instances.
     */
    @JvmName("yumwgpmikxpensuq")
    public suspend fun instanceCount(`value`: Output<Double>) {
        this.instanceCount = value
    }

    /**
     * @param value The subnet id.
     */
    @JvmName("gkcqbircodyiduxg")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Gets or sets the virtual machine configuration.
     */
    @JvmName("lhwbtkdlyrleueyg")
    public suspend fun virtualMachineConfiguration(`value`: Output<VirtualMachineConfigurationArgs>) {
        this.virtualMachineConfiguration = value
    }

    /**
     * @param value The number of app server instances.
     */
    @JvmName("jwjwsqpuadylvubc")
    public suspend fun instanceCount(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The subnet id.
     */
    @JvmName("rspyuarmwedbtxvd")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Gets or sets the virtual machine configuration.
     */
    @JvmName("xugorvyuypayewcl")
    public suspend fun virtualMachineConfiguration(`value`: VirtualMachineConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachineConfiguration = mapped
    }

    /**
     * @param argument Gets or sets the virtual machine configuration.
     */
    @JvmName("sjevpwqrarmniypt")
    public suspend
    fun virtualMachineConfiguration(argument: suspend VirtualMachineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineConfiguration = mapped
    }

    internal fun build(): ApplicationServerConfigurationArgs = ApplicationServerConfigurationArgs(
        instanceCount = instanceCount ?: throw PulumiNullFieldException("instanceCount"),
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
        virtualMachineConfiguration = virtualMachineConfiguration ?: throw
            PulumiNullFieldException("virtualMachineConfiguration"),
    )
}
