@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.CreateAndMountFileShareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the file share configuration where the transport directory fileshare is created and mounted as a part of the create infra flow. Please pre-create the resource group you intend to place the transport directory in. The storage account and fileshare will be auto-created by the ACSS and doesn’t need to pre-created.
 * @property configurationType The type of file share config.
 * Expected value is 'CreateAndMount'.
 * @property resourceGroup The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
 * @property storageAccountName The name of file share storage account name . A custom name is used in case of missing input.
 */
public data class CreateAndMountFileShareConfigurationArgs(
    public val configurationType: Output<String>,
    public val resourceGroup: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.CreateAndMountFileShareConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.CreateAndMountFileShareConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.CreateAndMountFileShareConfigurationArgs.builder()
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateAndMountFileShareConfigurationArgs].
 */
@PulumiTagMarker
public class CreateAndMountFileShareConfigurationArgsBuilder internal constructor() {
    private var configurationType: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    /**
     * @param value The type of file share config.
     * Expected value is 'CreateAndMount'.
     */
    @JvmName("bgojfaqcjleocicf")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
     */
    @JvmName("hodyjsqhwgdtipet")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The name of file share storage account name . A custom name is used in case of missing input.
     */
    @JvmName("fuhljllchycvdsvw")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value The type of file share config.
     * Expected value is 'CreateAndMount'.
     */
    @JvmName("oiemjnemocnokuof")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
     */
    @JvmName("rsibckdqagwgqyjm")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The name of file share storage account name . A custom name is used in case of missing input.
     */
    @JvmName("ydyupxtooaatrioj")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    internal fun build(): CreateAndMountFileShareConfigurationArgs =
        CreateAndMountFileShareConfigurationArgs(
            configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
            resourceGroup = resourceGroup,
            storageAccountName = storageAccountName,
        )
}
