@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DeployerVmPackagesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the url and storage account ID where deployer VM packages are uploaded
 * @property storageAccountId The deployer VM packages storage account id
 * @property url The URL to the deployer VM packages file.
 */
public data class DeployerVmPackagesArgs(
    public val storageAccountId: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DeployerVmPackagesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DeployerVmPackagesArgs =
        com.pulumi.azurenative.workloads.inputs.DeployerVmPackagesArgs.builder()
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeployerVmPackagesArgs].
 */
@PulumiTagMarker
public class DeployerVmPackagesArgsBuilder internal constructor() {
    private var storageAccountId: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The deployer VM packages storage account id
     */
    @JvmName("bbhbjtxbybmneyvv")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The URL to the deployer VM packages file.
     */
    @JvmName("vwcotsojebpepglf")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The deployer VM packages storage account id
     */
    @JvmName("dmhratidlftuilcg")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The URL to the deployer VM packages file.
     */
    @JvmName("frphrnyhqhqqdbhi")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): DeployerVmPackagesArgs = DeployerVmPackagesArgs(
        storageAccountId = storageAccountId,
        url = url,
    )
}
