@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DeploymentConfigurationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Deployment Configuration.
 * @property appLocation The geo-location where the SAP system is to be created.
 * @property configurationType The configuration Type.
 * Expected value is 'Deployment'.
 * @property infrastructureConfiguration The infrastructure configuration.
 * @property softwareConfiguration The software configuration.
 */
public data class DeploymentConfigurationArgs(
    public val appLocation: Output<String>? = null,
    public val configurationType: Output<String>,
    public val infrastructureConfiguration:
    Output<Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>>? = null,
    public val softwareConfiguration: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DeploymentConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DeploymentConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.DeploymentConfigurationArgs.builder()
            .appLocation(appLocation?.applyValue({ args0 -> args0 }))
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .infrastructureConfiguration(
                infrastructureConfiguration?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .softwareConfiguration(softwareConfiguration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentConfigurationArgsBuilder internal constructor() {
    private var appLocation: Output<String>? = null

    private var configurationType: Output<String>? = null

    private var infrastructureConfiguration:
        Output<Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>>? = null

    private var softwareConfiguration: Output<Any>? = null

    /**
     * @param value The geo-location where the SAP system is to be created.
     */
    @JvmName("rqloegvnegddkadv")
    public suspend fun appLocation(`value`: Output<String>) {
        this.appLocation = value
    }

    /**
     * @param value The configuration Type.
     * Expected value is 'Deployment'.
     */
    @JvmName("fotcfhcimqwhbwyi")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("feqkppdkftugtvnj")
    public suspend
    fun infrastructureConfiguration(`value`: Output<Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>>) {
        this.infrastructureConfiguration = value
    }

    /**
     * @param value The software configuration.
     */
    @JvmName("iqogdnmidebgvpon")
    public suspend fun softwareConfiguration(`value`: Output<Any>) {
        this.softwareConfiguration = value
    }

    /**
     * @param value The geo-location where the SAP system is to be created.
     */
    @JvmName("xpeabgjwbmdniknh")
    public suspend fun appLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appLocation = mapped
    }

    /**
     * @param value The configuration Type.
     * Expected value is 'Deployment'.
     */
    @JvmName("cddatvhnfnsepfic")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("ceuvfhyjyjeglygd")
    public suspend
    fun infrastructureConfiguration(`value`: Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureConfiguration = mapped
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("tvnwrscguwvhnlpl")
    public fun infrastructureConfiguration(`value`: SingleServerConfigurationArgs) {
        val toBeMapped = Either.ofLeft<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureConfiguration = mapped
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("ipgwgieknquhedsk")
    public fun infrastructureConfiguration(`value`: ThreeTierConfigurationArgs) {
        val toBeMapped = Either.ofRight<SingleServerConfigurationArgs,
            ThreeTierConfigurationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureConfiguration = mapped
    }

    /**
     * @param value The software configuration.
     */
    @JvmName("nvutbofgcagreqte")
    public suspend fun softwareConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareConfiguration = mapped
    }

    internal fun build(): DeploymentConfigurationArgs = DeploymentConfigurationArgs(
        appLocation = appLocation,
        configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
        infrastructureConfiguration = infrastructureConfiguration,
        softwareConfiguration = softwareConfiguration,
    )
}
