@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DiscoveryConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Discovery Details.
 * @property centralServerVmId The virtual machine ID of the Central Server.
 * @property configurationType The configuration Type.
 * Expected value is 'Discovery'.
 * @property managedRgStorageAccountName The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
 */
public data class DiscoveryConfigurationArgs(
    public val centralServerVmId: Output<String>? = null,
    public val configurationType: Output<String>,
    public val managedRgStorageAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DiscoveryConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DiscoveryConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.DiscoveryConfigurationArgs.builder()
            .centralServerVmId(centralServerVmId?.applyValue({ args0 -> args0 }))
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .managedRgStorageAccountName(managedRgStorageAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiscoveryConfigurationArgs].
 */
@PulumiTagMarker
public class DiscoveryConfigurationArgsBuilder internal constructor() {
    private var centralServerVmId: Output<String>? = null

    private var configurationType: Output<String>? = null

    private var managedRgStorageAccountName: Output<String>? = null

    /**
     * @param value The virtual machine ID of the Central Server.
     */
    @JvmName("dgtemjnrwictmmay")
    public suspend fun centralServerVmId(`value`: Output<String>) {
        this.centralServerVmId = value
    }

    /**
     * @param value The configuration Type.
     * Expected value is 'Discovery'.
     */
    @JvmName("frcpiinbqdjfxwet")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
     */
    @JvmName("jrgngjtsvfeapkti")
    public suspend fun managedRgStorageAccountName(`value`: Output<String>) {
        this.managedRgStorageAccountName = value
    }

    /**
     * @param value The virtual machine ID of the Central Server.
     */
    @JvmName("oyjlkvnmpctwjrhl")
    public suspend fun centralServerVmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.centralServerVmId = mapped
    }

    /**
     * @param value The configuration Type.
     * Expected value is 'Discovery'.
     */
    @JvmName("xvljjahujwjhlwfk")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
     */
    @JvmName("pqtuvuaspupipsoa")
    public suspend fun managedRgStorageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRgStorageAccountName = mapped
    }

    internal fun build(): DiscoveryConfigurationArgs = DiscoveryConfigurationArgs(
        centralServerVmId = centralServerVmId,
        configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
        managedRgStorageAccountName = managedRgStorageAccountName,
    )
}
