@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DiskExclusionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the disk exclusion properties for virtual machine backup.
 * @property diskLunList List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
 * @property isInclusionList Flag to indicate whether DiskLunList is to be included/ excluded from backup.
 */
public data class DiskExclusionPropertiesArgs(
    public val diskLunList: Output<List<Int>>,
    public val isInclusionList: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DiskExclusionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DiskExclusionPropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.DiskExclusionPropertiesArgs.builder()
            .diskLunList(diskLunList.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isInclusionList(isInclusionList.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskExclusionPropertiesArgs].
 */
@PulumiTagMarker
public class DiskExclusionPropertiesArgsBuilder internal constructor() {
    private var diskLunList: Output<List<Int>>? = null

    private var isInclusionList: Output<Boolean>? = null

    /**
     * @param value List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("isupxsteeprmolsx")
    public suspend fun diskLunList(`value`: Output<List<Int>>) {
        this.diskLunList = value
    }

    @JvmName("llkghntvlrjankao")
    public suspend fun diskLunList(vararg values: Output<Int>) {
        this.diskLunList = Output.all(values.asList())
    }

    /**
     * @param values List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("jgdrbbonvgipiawc")
    public suspend fun diskLunList(values: List<Output<Int>>) {
        this.diskLunList = Output.all(values)
    }

    /**
     * @param value Flag to indicate whether DiskLunList is to be included/ excluded from backup.
     */
    @JvmName("thlyngofvjujkaop")
    public suspend fun isInclusionList(`value`: Output<Boolean>) {
        this.isInclusionList = value
    }

    /**
     * @param value List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("abkhonfaoylmxpbl")
    public suspend fun diskLunList(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskLunList = mapped
    }

    /**
     * @param values List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("wgofmxdimeyiuuak")
    public suspend fun diskLunList(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskLunList = mapped
    }

    /**
     * @param value Flag to indicate whether DiskLunList is to be included/ excluded from backup.
     */
    @JvmName("yiyrfypkprgldkrt")
    public suspend fun isInclusionList(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isInclusionList = mapped
    }

    internal fun build(): DiskExclusionPropertiesArgs = DiskExclusionPropertiesArgs(
        diskLunList = diskLunList ?: throw PulumiNullFieldException("diskLunList"),
        isInclusionList = isInclusionList ?: throw PulumiNullFieldException("isInclusionList"),
    )
}
