@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPCentralInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property centralInstanceName Central Services Instance resource name string modeled as parameter for auto generation to work correctly.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
 */
public data class GetSAPCentralInstancePlainArgs(
    public val centralInstanceName: String,
    public val resourceGroupName: String,
    public val sapVirtualInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPCentralInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSAPCentralInstancePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPCentralInstancePlainArgs.builder()
            .centralInstanceName(centralInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapVirtualInstanceName(sapVirtualInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSAPCentralInstancePlainArgs].
 */
@PulumiTagMarker
public class GetSAPCentralInstancePlainArgsBuilder internal constructor() {
    private var centralInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var sapVirtualInstanceName: String? = null

    /**
     * @param value Central Services Instance resource name string modeled as parameter for auto generation to work correctly.
     */
    @JvmName("pqciosrdkukeqcrq")
    public suspend fun centralInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.centralInstanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmhxrjycnmryquhr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Instances for SAP solutions resource
     */
    @JvmName("sqcvtchefsumeuyy")
    public suspend fun sapVirtualInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapVirtualInstanceName = mapped
    }

    internal fun build(): GetSAPCentralInstancePlainArgs = GetSAPCentralInstancePlainArgs(
        centralInstanceName = centralInstanceName ?: throw PulumiNullFieldException("centralInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapVirtualInstanceName = sapVirtualInstanceName ?: throw
            PulumiNullFieldException("sapVirtualInstanceName"),
    )
}
