@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPDatabaseInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseInstanceName Database resource name string modeled as parameter for auto generation to work correctly.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
 */
public data class GetSAPDatabaseInstancePlainArgs(
    public val databaseInstanceName: String,
    public val resourceGroupName: String,
    public val sapVirtualInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPDatabaseInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSAPDatabaseInstancePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPDatabaseInstancePlainArgs.builder()
            .databaseInstanceName(databaseInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapVirtualInstanceName(sapVirtualInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSAPDatabaseInstancePlainArgs].
 */
@PulumiTagMarker
public class GetSAPDatabaseInstancePlainArgsBuilder internal constructor() {
    private var databaseInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var sapVirtualInstanceName: String? = null

    /**
     * @param value Database resource name string modeled as parameter for auto generation to work correctly.
     */
    @JvmName("xmlnopudjedknvns")
    public suspend fun databaseInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseInstanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nwfgemedwcjnsdtd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Instances for SAP solutions resource
     */
    @JvmName("ixiiuaxiowspqxtk")
    public suspend fun sapVirtualInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapVirtualInstanceName = mapped
    }

    internal fun build(): GetSAPDatabaseInstancePlainArgs = GetSAPDatabaseInstancePlainArgs(
        databaseInstanceName = databaseInstanceName ?: throw
            PulumiNullFieldException("databaseInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapVirtualInstanceName = sapVirtualInstanceName ?: throw
            PulumiNullFieldException("sapVirtualInstanceName"),
    )
}
