@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetServerInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapDiscoverySiteName The name of the discovery site resource for SAP Migration.
 * @property sapInstanceName The name of SAP Instance resource for SAP Migration.
 * @property serverInstanceName The name of the Server instance resource for SAP Migration.
 */
public data class GetServerInstancePlainArgs(
    public val resourceGroupName: String,
    public val sapDiscoverySiteName: String,
    public val sapInstanceName: String,
    public val serverInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetServerInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetServerInstancePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetServerInstancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapDiscoverySiteName(sapDiscoverySiteName.let({ args0 -> args0 }))
            .sapInstanceName(sapInstanceName.let({ args0 -> args0 }))
            .serverInstanceName(serverInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerInstancePlainArgs].
 */
@PulumiTagMarker
public class GetServerInstancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sapDiscoverySiteName: String? = null

    private var sapInstanceName: String? = null

    private var serverInstanceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bucivwunlfrjnuie")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("vliqouujypyvnpck")
    public suspend fun sapDiscoverySiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapDiscoverySiteName = mapped
    }

    /**
     * @param value The name of SAP Instance resource for SAP Migration.
     */
    @JvmName("bbprhoxaeterasnj")
    public suspend fun sapInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapInstanceName = mapped
    }

    /**
     * @param value The name of the Server instance resource for SAP Migration.
     */
    @JvmName("mjvwexpqfpnhjslw")
    public suspend fun serverInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverInstanceName = mapped
    }

    internal fun build(): GetServerInstancePlainArgs = GetServerInstancePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapDiscoverySiteName = sapDiscoverySiteName ?: throw
            PulumiNullFieldException("sapDiscoverySiteName"),
        sapInstanceName = sapInstanceName ?: throw PulumiNullFieldException("sapInstanceName"),
        serverInstanceName = serverInstanceName ?: throw PulumiNullFieldException("serverInstanceName"),
    )
}
