@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.HighAvailabilitySoftwareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the HA software configuration.
 * @property fencingClientId The fencing client id.
 * @property fencingClientPassword The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
 */
public data class HighAvailabilitySoftwareConfigurationArgs(
    public val fencingClientId: Output<String>,
    public val fencingClientPassword: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.HighAvailabilitySoftwareConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.HighAvailabilitySoftwareConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.HighAvailabilitySoftwareConfigurationArgs.builder()
            .fencingClientId(fencingClientId.applyValue({ args0 -> args0 }))
            .fencingClientPassword(fencingClientPassword.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HighAvailabilitySoftwareConfigurationArgs].
 */
@PulumiTagMarker
public class HighAvailabilitySoftwareConfigurationArgsBuilder internal constructor() {
    private var fencingClientId: Output<String>? = null

    private var fencingClientPassword: Output<String>? = null

    /**
     * @param value The fencing client id.
     */
    @JvmName("qrrmuirbsyuhicuf")
    public suspend fun fencingClientId(`value`: Output<String>) {
        this.fencingClientId = value
    }

    /**
     * @param value The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
     */
    @JvmName("bptompvaouqpanyb")
    public suspend fun fencingClientPassword(`value`: Output<String>) {
        this.fencingClientPassword = value
    }

    /**
     * @param value The fencing client id.
     */
    @JvmName("csfqjcjfyotuvscg")
    public suspend fun fencingClientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fencingClientId = mapped
    }

    /**
     * @param value The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
     */
    @JvmName("blcuqjtupflipbty")
    public suspend fun fencingClientPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fencingClientPassword = mapped
    }

    internal fun build(): HighAvailabilitySoftwareConfigurationArgs =
        HighAvailabilitySoftwareConfigurationArgs(
            fencingClientId = fencingClientId ?: throw PulumiNullFieldException("fencingClientId"),
            fencingClientPassword = fencingClientPassword ?: throw
                PulumiNullFieldException("fencingClientPassword"),
        )
}
