@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.LongTermRetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Long term retention policy.
 * @property dailySchedule Daily retention schedule of the protection policy.
 * @property monthlySchedule Monthly retention schedule of the protection policy.
 * @property retentionPolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'LongTermRetentionPolicy'.
 * @property weeklySchedule Weekly retention schedule of the protection policy.
 * @property yearlySchedule Yearly retention schedule of the protection policy.
 */
public data class LongTermRetentionPolicyArgs(
    public val dailySchedule: Output<DailyRetentionScheduleArgs>? = null,
    public val monthlySchedule: Output<MonthlyRetentionScheduleArgs>? = null,
    public val retentionPolicyType: Output<String>,
    public val weeklySchedule: Output<WeeklyRetentionScheduleArgs>? = null,
    public val yearlySchedule: Output<YearlyRetentionScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.LongTermRetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.LongTermRetentionPolicyArgs =
        com.pulumi.azurenative.workloads.inputs.LongTermRetentionPolicyArgs.builder()
            .dailySchedule(dailySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monthlySchedule(monthlySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionPolicyType(retentionPolicyType.applyValue({ args0 -> args0 }))
            .weeklySchedule(weeklySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .yearlySchedule(
                yearlySchedule?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LongTermRetentionPolicyArgs].
 */
@PulumiTagMarker
public class LongTermRetentionPolicyArgsBuilder internal constructor() {
    private var dailySchedule: Output<DailyRetentionScheduleArgs>? = null

    private var monthlySchedule: Output<MonthlyRetentionScheduleArgs>? = null

    private var retentionPolicyType: Output<String>? = null

    private var weeklySchedule: Output<WeeklyRetentionScheduleArgs>? = null

    private var yearlySchedule: Output<YearlyRetentionScheduleArgs>? = null

    /**
     * @param value Daily retention schedule of the protection policy.
     */
    @JvmName("ujduwdyliopndyww")
    public suspend fun dailySchedule(`value`: Output<DailyRetentionScheduleArgs>) {
        this.dailySchedule = value
    }

    /**
     * @param value Monthly retention schedule of the protection policy.
     */
    @JvmName("txodaxdnuhmrfsvv")
    public suspend fun monthlySchedule(`value`: Output<MonthlyRetentionScheduleArgs>) {
        this.monthlySchedule = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'LongTermRetentionPolicy'.
     */
    @JvmName("kvjgyuybmgvhuxkj")
    public suspend fun retentionPolicyType(`value`: Output<String>) {
        this.retentionPolicyType = value
    }

    /**
     * @param value Weekly retention schedule of the protection policy.
     */
    @JvmName("pdtawapbxfegmkdv")
    public suspend fun weeklySchedule(`value`: Output<WeeklyRetentionScheduleArgs>) {
        this.weeklySchedule = value
    }

    /**
     * @param value Yearly retention schedule of the protection policy.
     */
    @JvmName("hvshgtoabvynidrq")
    public suspend fun yearlySchedule(`value`: Output<YearlyRetentionScheduleArgs>) {
        this.yearlySchedule = value
    }

    /**
     * @param value Daily retention schedule of the protection policy.
     */
    @JvmName("odxeqvqrfmhftmxk")
    public suspend fun dailySchedule(`value`: DailyRetentionScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailySchedule = mapped
    }

    /**
     * @param argument Daily retention schedule of the protection policy.
     */
    @JvmName("rhhgaarvvulfajfd")
    public suspend fun dailySchedule(argument: suspend DailyRetentionScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = DailyRetentionScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dailySchedule = mapped
    }

    /**
     * @param value Monthly retention schedule of the protection policy.
     */
    @JvmName("hcjcjvllxnphrjtm")
    public suspend fun monthlySchedule(`value`: MonthlyRetentionScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlySchedule = mapped
    }

    /**
     * @param argument Monthly retention schedule of the protection policy.
     */
    @JvmName("gapdeljtfgjvsdxb")
    public suspend
    fun monthlySchedule(argument: suspend MonthlyRetentionScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = MonthlyRetentionScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monthlySchedule = mapped
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'LongTermRetentionPolicy'.
     */
    @JvmName("omysqpkfqmxcvfba")
    public suspend fun retentionPolicyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicyType = mapped
    }

    /**
     * @param value Weekly retention schedule of the protection policy.
     */
    @JvmName("xipwiqnxdhsbnovm")
    public suspend fun weeklySchedule(`value`: WeeklyRetentionScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklySchedule = mapped
    }

    /**
     * @param argument Weekly retention schedule of the protection policy.
     */
    @JvmName("fxrrewestfdqgset")
    public suspend
    fun weeklySchedule(argument: suspend WeeklyRetentionScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = WeeklyRetentionScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.weeklySchedule = mapped
    }

    /**
     * @param value Yearly retention schedule of the protection policy.
     */
    @JvmName("yecnwfshfoumrxjx")
    public suspend fun yearlySchedule(`value`: YearlyRetentionScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.yearlySchedule = mapped
    }

    /**
     * @param argument Yearly retention schedule of the protection policy.
     */
    @JvmName("gvfelnwpswabfbrx")
    public suspend
    fun yearlySchedule(argument: suspend YearlyRetentionScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = YearlyRetentionScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.yearlySchedule = mapped
    }

    internal fun build(): LongTermRetentionPolicyArgs = LongTermRetentionPolicyArgs(
        dailySchedule = dailySchedule,
        monthlySchedule = monthlySchedule,
        retentionPolicyType = retentionPolicyType ?: throw PulumiNullFieldException("retentionPolicyType"),
        weeklySchedule = weeklySchedule,
        yearlySchedule = yearlySchedule,
    )
}
