@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.ManagedRGConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed resource group configuration
 * @property name Managed resource group name
 */
public data class ManagedRGConfigurationArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.ManagedRGConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.ManagedRGConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.ManagedRGConfigurationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedRGConfigurationArgs].
 */
@PulumiTagMarker
public class ManagedRGConfigurationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Managed resource group name
     */
    @JvmName("fsiqrltkodsrdkax")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Managed resource group name
     */
    @JvmName("xjvothcgebajhlly")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagedRGConfigurationArgs = ManagedRGConfigurationArgs(
        name = name,
    )
}
