@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.OsSapConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the OS and SAP Configurations for Deployment
 * @property deployerVmPackages The url and storage account ID where deployer VM packages are uploaded
 * @property sapFqdn The FQDN to set for the SAP system
 */
public data class OsSapConfigurationArgs(
    public val deployerVmPackages: Output<DeployerVmPackagesArgs>? = null,
    public val sapFqdn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.OsSapConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.OsSapConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.OsSapConfigurationArgs.builder()
            .deployerVmPackages(
                deployerVmPackages?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sapFqdn(sapFqdn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OsSapConfigurationArgs].
 */
@PulumiTagMarker
public class OsSapConfigurationArgsBuilder internal constructor() {
    private var deployerVmPackages: Output<DeployerVmPackagesArgs>? = null

    private var sapFqdn: Output<String>? = null

    /**
     * @param value The url and storage account ID where deployer VM packages are uploaded
     */
    @JvmName("hvwemqpnufxgyiqn")
    public suspend fun deployerVmPackages(`value`: Output<DeployerVmPackagesArgs>) {
        this.deployerVmPackages = value
    }

    /**
     * @param value The FQDN to set for the SAP system
     */
    @JvmName("mivalowtdudovrdn")
    public suspend fun sapFqdn(`value`: Output<String>) {
        this.sapFqdn = value
    }

    /**
     * @param value The url and storage account ID where deployer VM packages are uploaded
     */
    @JvmName("fydenfqokqdqcdfd")
    public suspend fun deployerVmPackages(`value`: DeployerVmPackagesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployerVmPackages = mapped
    }

    /**
     * @param argument The url and storage account ID where deployer VM packages are uploaded
     */
    @JvmName("xikfjxmpomyqqato")
    public suspend
    fun deployerVmPackages(argument: suspend DeployerVmPackagesArgsBuilder.() -> Unit) {
        val toBeMapped = DeployerVmPackagesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deployerVmPackages = mapped
    }

    /**
     * @param value The FQDN to set for the SAP system
     */
    @JvmName("rrrfirjowukgeogn")
    public suspend fun sapFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapFqdn = mapped
    }

    internal fun build(): OsSapConfigurationArgs = OsSapConfigurationArgs(
        deployerVmPackages = deployerVmPackages,
        sapFqdn = sapFqdn,
    )
}
