@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorMetricThresholdsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the Threshold Values for Top Metrics Health.
 * @property green Gets or sets the threshold value for Green.
 * @property name Gets or sets the name of the threshold.
 * @property red Gets or sets the threshold value for Red.
 * @property yellow Gets or sets the threshold value for Yellow.
 */
public data class SapLandscapeMonitorMetricThresholdsArgs(
    public val green: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val red: Output<Double>? = null,
    public val yellow: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorMetricThresholdsArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorMetricThresholdsArgs =
        com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorMetricThresholdsArgs.builder()
            .green(green?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .red(red?.applyValue({ args0 -> args0 }))
            .yellow(yellow?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapLandscapeMonitorMetricThresholdsArgs].
 */
@PulumiTagMarker
public class SapLandscapeMonitorMetricThresholdsArgsBuilder internal constructor() {
    private var green: Output<Double>? = null

    private var name: Output<String>? = null

    private var red: Output<Double>? = null

    private var yellow: Output<Double>? = null

    /**
     * @param value Gets or sets the threshold value for Green.
     */
    @JvmName("dxilqsoudgtvmufh")
    public suspend fun green(`value`: Output<Double>) {
        this.green = value
    }

    /**
     * @param value Gets or sets the name of the threshold.
     */
    @JvmName("nkoyqwhdqmpqggpk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the threshold value for Red.
     */
    @JvmName("ateenibtdjmesmhj")
    public suspend fun red(`value`: Output<Double>) {
        this.red = value
    }

    /**
     * @param value Gets or sets the threshold value for Yellow.
     */
    @JvmName("xiemakkcprqawdxa")
    public suspend fun yellow(`value`: Output<Double>) {
        this.yellow = value
    }

    /**
     * @param value Gets or sets the threshold value for Green.
     */
    @JvmName("jutxjfdjrriiefey")
    public suspend fun green(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.green = mapped
    }

    /**
     * @param value Gets or sets the name of the threshold.
     */
    @JvmName("htpyiklcgmwisjgi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the threshold value for Red.
     */
    @JvmName("njhdrsxeyjhutsuj")
    public suspend fun red(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.red = mapped
    }

    /**
     * @param value Gets or sets the threshold value for Yellow.
     */
    @JvmName("djgfngjssqrfuimg")
    public suspend fun yellow(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.yellow = mapped
    }

    internal fun build(): SapLandscapeMonitorMetricThresholdsArgs =
        SapLandscapeMonitorMetricThresholdsArgs(
            green = green,
            name = name,
            red = red,
            yellow = yellow,
        )
}
