@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SimpleRetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Simple policy retention.
 * @property retentionDuration Retention duration of the protection policy.
 * @property retentionPolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'SimpleRetentionPolicy'.
 */
public data class SimpleRetentionPolicyArgs(
    public val retentionDuration: Output<RetentionDurationArgs>? = null,
    public val retentionPolicyType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SimpleRetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SimpleRetentionPolicyArgs =
        com.pulumi.azurenative.workloads.inputs.SimpleRetentionPolicyArgs.builder()
            .retentionDuration(retentionDuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionPolicyType(retentionPolicyType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SimpleRetentionPolicyArgs].
 */
@PulumiTagMarker
public class SimpleRetentionPolicyArgsBuilder internal constructor() {
    private var retentionDuration: Output<RetentionDurationArgs>? = null

    private var retentionPolicyType: Output<String>? = null

    /**
     * @param value Retention duration of the protection policy.
     */
    @JvmName("mmwnenddaxmxuwoi")
    public suspend fun retentionDuration(`value`: Output<RetentionDurationArgs>) {
        this.retentionDuration = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'SimpleRetentionPolicy'.
     */
    @JvmName("aveqhdibakuhchby")
    public suspend fun retentionPolicyType(`value`: Output<String>) {
        this.retentionPolicyType = value
    }

    /**
     * @param value Retention duration of the protection policy.
     */
    @JvmName("dktbgufmjnvkivfj")
    public suspend fun retentionDuration(`value`: RetentionDurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDuration = mapped
    }

    /**
     * @param argument Retention duration of the protection policy.
     */
    @JvmName("oxhbokfsruinmxdn")
    public suspend fun retentionDuration(argument: suspend RetentionDurationArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionDurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionDuration = mapped
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'SimpleRetentionPolicy'.
     */
    @JvmName("uyhnskxvprekmqri")
    public suspend fun retentionPolicyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicyType = mapped
    }

    internal fun build(): SimpleRetentionPolicyArgs = SimpleRetentionPolicyArgs(
        retentionDuration = retentionDuration,
        retentionPolicyType = retentionPolicyType ?: throw PulumiNullFieldException("retentionPolicyType"),
    )
}
