@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SingleServerFullResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The resource name object where the specified values will be full resource names of the corresponding resources in a single server SAP system.
 * @property namingPatternType The pattern type to be used for resource naming.
 * Expected value is 'FullResourceName'.
 * @property virtualMachine The resource names object for virtual machine and related resources.
 */
public data class SingleServerFullResourceNamesArgs(
    public val namingPatternType: Output<String>,
    public val virtualMachine: Output<VirtualMachineResourceNamesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SingleServerFullResourceNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SingleServerFullResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.SingleServerFullResourceNamesArgs.builder()
            .namingPatternType(namingPatternType.applyValue({ args0 -> args0 }))
            .virtualMachine(
                virtualMachine?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SingleServerFullResourceNamesArgs].
 */
@PulumiTagMarker
public class SingleServerFullResourceNamesArgsBuilder internal constructor() {
    private var namingPatternType: Output<String>? = null

    private var virtualMachine: Output<VirtualMachineResourceNamesArgs>? = null

    /**
     * @param value The pattern type to be used for resource naming.
     * Expected value is 'FullResourceName'.
     */
    @JvmName("dwyxjxetnjngdkcd")
    public suspend fun namingPatternType(`value`: Output<String>) {
        this.namingPatternType = value
    }

    /**
     * @param value The resource names object for virtual machine and related resources.
     */
    @JvmName("rhcnqfqqeettuotc")
    public suspend fun virtualMachine(`value`: Output<VirtualMachineResourceNamesArgs>) {
        this.virtualMachine = value
    }

    /**
     * @param value The pattern type to be used for resource naming.
     * Expected value is 'FullResourceName'.
     */
    @JvmName("guxtsxiccbxgflvi")
    public suspend fun namingPatternType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namingPatternType = mapped
    }

    /**
     * @param value The resource names object for virtual machine and related resources.
     */
    @JvmName("cmfdbjwjafaugkcu")
    public suspend fun virtualMachine(`value`: VirtualMachineResourceNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachine = mapped
    }

    /**
     * @param argument The resource names object for virtual machine and related resources.
     */
    @JvmName("glutsbuyyjpheiay")
    public suspend
    fun virtualMachine(argument: suspend VirtualMachineResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineResourceNamesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachine = mapped
    }

    internal fun build(): SingleServerFullResourceNamesArgs = SingleServerFullResourceNamesArgs(
        namingPatternType = namingPatternType ?: throw PulumiNullFieldException("namingPatternType"),
        virtualMachine = virtualMachine,
    )
}
