@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SubProtectionPolicyArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.PolicyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Sub-protection policy which includes schedule and retention
 * @property policyType Type of backup policy type
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property snapshotBackupAdditionalDetails Hana DB instance snapshot backup additional details.
 * @property tieringPolicy Tiering policy to automatically move RPs to another tier.
 * Key is Target Tier, defined in RecoveryPointTierType enum.
 * Tiering policy specifies the criteria to move RP to the target tier.
 */
public data class SubProtectionPolicyArgs(
    public val policyType: Output<Either<String, PolicyType>>? = null,
    public val retentionPolicy:
    Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null,
    public val schedulePolicy: Output<Any>? = null,
    public val snapshotBackupAdditionalDetails: Output<SnapshotBackupAdditionalDetailsArgs>? = null,
    public val tieringPolicy: Output<Map<String, TieringPolicyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SubProtectionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SubProtectionPolicyArgs =
        com.pulumi.azurenative.workloads.inputs.SubProtectionPolicyArgs.builder()
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .retentionPolicy(
                retentionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .schedulePolicy(schedulePolicy?.applyValue({ args0 -> args0 }))
            .snapshotBackupAdditionalDetails(
                snapshotBackupAdditionalDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tieringPolicy(
                tieringPolicy?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubProtectionPolicyArgs].
 */
@PulumiTagMarker
public class SubProtectionPolicyArgsBuilder internal constructor() {
    private var policyType: Output<Either<String, PolicyType>>? = null

    private var retentionPolicy:
        Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null

    private var schedulePolicy: Output<Any>? = null

    private var snapshotBackupAdditionalDetails: Output<SnapshotBackupAdditionalDetailsArgs>? = null

    private var tieringPolicy: Output<Map<String, TieringPolicyArgs>>? = null

    /**
     * @param value Type of backup policy type
     */
    @JvmName("uxlooyaucqsuxcib")
    public suspend fun policyType(`value`: Output<Either<String, PolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("pynmpatuhxxxilhf")
    public suspend
    fun retentionPolicy(`value`: Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>) {
        this.retentionPolicy = value
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("guewxyljoaehufhp")
    public suspend fun schedulePolicy(`value`: Output<Any>) {
        this.schedulePolicy = value
    }

    /**
     * @param value Hana DB instance snapshot backup additional details.
     */
    @JvmName("ejmvupsqetdwvdbh")
    public suspend
    fun snapshotBackupAdditionalDetails(`value`: Output<SnapshotBackupAdditionalDetailsArgs>) {
        this.snapshotBackupAdditionalDetails = value
    }

    /**
     * @param value Tiering policy to automatically move RPs to another tier.
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("hrstvhrtfnamuqas")
    public suspend fun tieringPolicy(`value`: Output<Map<String, TieringPolicyArgs>>) {
        this.tieringPolicy = value
    }

    /**
     * @param value Type of backup policy type
     */
    @JvmName("agjblucnwdtlojfk")
    public suspend fun policyType(`value`: Either<String, PolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Type of backup policy type
     */
    @JvmName("vjxcxpcubevxxtsw")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Type of backup policy type
     */
    @JvmName("naleorddcaykstli")
    public fun policyType(`value`: PolicyType) {
        val toBeMapped = Either.ofRight<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("mqbxtqxefofsuqvk")
    public suspend
    fun retentionPolicy(`value`: Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("hikhxblcchiysoin")
    public fun retentionPolicy(`value`: LongTermRetentionPolicyArgs) {
        val toBeMapped = Either.ofLeft<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("soqfmftbrhnjikpj")
    public fun retentionPolicy(`value`: SimpleRetentionPolicyArgs) {
        val toBeMapped = Either.ofRight<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("vfqulcticyatueve")
    public suspend fun schedulePolicy(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulePolicy = mapped
    }

    /**
     * @param value Hana DB instance snapshot backup additional details.
     */
    @JvmName("aavixuumykqmitfb")
    public suspend
    fun snapshotBackupAdditionalDetails(`value`: SnapshotBackupAdditionalDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotBackupAdditionalDetails = mapped
    }

    /**
     * @param argument Hana DB instance snapshot backup additional details.
     */
    @JvmName("tmubuptyeidsexel")
    public suspend
    fun snapshotBackupAdditionalDetails(argument: suspend SnapshotBackupAdditionalDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = SnapshotBackupAdditionalDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snapshotBackupAdditionalDetails = mapped
    }

    /**
     * @param value Tiering policy to automatically move RPs to another tier.
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("cmsavubxukuburlt")
    public suspend fun tieringPolicy(`value`: Map<String, TieringPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tieringPolicy = mapped
    }

    /**
     * @param argument Tiering policy to automatically move RPs to another tier.
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("semhjfxnnmnfonoh")
    public suspend fun tieringPolicy(
        vararg
        argument: Pair<String, suspend TieringPolicyArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                TieringPolicyArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.tieringPolicy = mapped
    }

    /**
     * @param values Tiering policy to automatically move RPs to another tier.
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("gqrcqwjtiinlrney")
    public fun tieringPolicy(vararg values: Pair<String, TieringPolicyArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tieringPolicy = mapped
    }

    internal fun build(): SubProtectionPolicyArgs = SubProtectionPolicyArgs(
        policyType = policyType,
        retentionPolicy = retentionPolicy,
        schedulePolicy = schedulePolicy,
        snapshotBackupAdditionalDetails = snapshotBackupAdditionalDetails,
        tieringPolicy = tieringPolicy,
    )
}
