@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.ThreeTierFullResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The resource name object where the specified values will be full resource names of the corresponding resources in a three tier SAP system.
 * @property applicationServer The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
 * @property centralServer The full resource names object for central server layer resources.
 * @property databaseServer The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
 * @property namingPatternType The pattern type to be used for resource naming.
 * Expected value is 'FullResourceName'.
 * @property sharedStorage The resource names object for shared storage.
 */
public data class ThreeTierFullResourceNamesArgs(
    public val applicationServer: Output<ApplicationServerFullResourceNamesArgs>? = null,
    public val centralServer: Output<CentralServerFullResourceNamesArgs>? = null,
    public val databaseServer: Output<DatabaseServerFullResourceNamesArgs>? = null,
    public val namingPatternType: Output<String>,
    public val sharedStorage: Output<SharedStorageResourceNamesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.ThreeTierFullResourceNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.ThreeTierFullResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.ThreeTierFullResourceNamesArgs.builder()
            .applicationServer(applicationServer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .centralServer(centralServer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databaseServer(databaseServer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .namingPatternType(namingPatternType.applyValue({ args0 -> args0 }))
            .sharedStorage(sharedStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ThreeTierFullResourceNamesArgs].
 */
@PulumiTagMarker
public class ThreeTierFullResourceNamesArgsBuilder internal constructor() {
    private var applicationServer: Output<ApplicationServerFullResourceNamesArgs>? = null

    private var centralServer: Output<CentralServerFullResourceNamesArgs>? = null

    private var databaseServer: Output<DatabaseServerFullResourceNamesArgs>? = null

    private var namingPatternType: Output<String>? = null

    private var sharedStorage: Output<SharedStorageResourceNamesArgs>? = null

    /**
     * @param value The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
     */
    @JvmName("txyaubhmxrmxfftj")
    public suspend fun applicationServer(`value`: Output<ApplicationServerFullResourceNamesArgs>) {
        this.applicationServer = value
    }

    /**
     * @param value The full resource names object for central server layer resources.
     */
    @JvmName("iteqyhbtndybboam")
    public suspend fun centralServer(`value`: Output<CentralServerFullResourceNamesArgs>) {
        this.centralServer = value
    }

    /**
     * @param value The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
     */
    @JvmName("mrdinvhrilkdqxgh")
    public suspend fun databaseServer(`value`: Output<DatabaseServerFullResourceNamesArgs>) {
        this.databaseServer = value
    }

    /**
     * @param value The pattern type to be used for resource naming.
     * Expected value is 'FullResourceName'.
     */
    @JvmName("lxtrhpwbdtshpckt")
    public suspend fun namingPatternType(`value`: Output<String>) {
        this.namingPatternType = value
    }

    /**
     * @param value The resource names object for shared storage.
     */
    @JvmName("tblfilysigkkmuhj")
    public suspend fun sharedStorage(`value`: Output<SharedStorageResourceNamesArgs>) {
        this.sharedStorage = value
    }

    /**
     * @param value The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
     */
    @JvmName("etgaqmnxqiuemfkt")
    public suspend fun applicationServer(`value`: ApplicationServerFullResourceNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationServer = mapped
    }

    /**
     * @param argument The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
     */
    @JvmName("yrrvpsubhwevuheg")
    public suspend
    fun applicationServer(argument: suspend ApplicationServerFullResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationServerFullResourceNamesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.applicationServer = mapped
    }

    /**
     * @param value The full resource names object for central server layer resources.
     */
    @JvmName("owbwbcnnbrkepjqs")
    public suspend fun centralServer(`value`: CentralServerFullResourceNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.centralServer = mapped
    }

    /**
     * @param argument The full resource names object for central server layer resources.
     */
    @JvmName("qbbgkaequnvmlued")
    public suspend
    fun centralServer(argument: suspend CentralServerFullResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = CentralServerFullResourceNamesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.centralServer = mapped
    }

    /**
     * @param value The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
     */
    @JvmName("rcsgawggrqrqngno")
    public suspend fun databaseServer(`value`: DatabaseServerFullResourceNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseServer = mapped
    }

    /**
     * @param argument The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
     */
    @JvmName("dtdmscjpxqoxvpqq")
    public suspend
    fun databaseServer(argument: suspend DatabaseServerFullResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = DatabaseServerFullResourceNamesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.databaseServer = mapped
    }

    /**
     * @param value The pattern type to be used for resource naming.
     * Expected value is 'FullResourceName'.
     */
    @JvmName("esfejaqdtlmvikbd")
    public suspend fun namingPatternType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namingPatternType = mapped
    }

    /**
     * @param value The resource names object for shared storage.
     */
    @JvmName("feemjtptuqtxiqmx")
    public suspend fun sharedStorage(`value`: SharedStorageResourceNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedStorage = mapped
    }

    /**
     * @param argument The resource names object for shared storage.
     */
    @JvmName("lclmpevpnpjyxdcn")
    public suspend
    fun sharedStorage(argument: suspend SharedStorageResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = SharedStorageResourceNamesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sharedStorage = mapped
    }

    internal fun build(): ThreeTierFullResourceNamesArgs = ThreeTierFullResourceNamesArgs(
        applicationServer = applicationServer,
        centralServer = centralServer,
        databaseServer = databaseServer,
        namingPatternType = namingPatternType ?: throw PulumiNullFieldException("namingPatternType"),
        sharedStorage = sharedStorage,
    )
}
